<?php

namespace GreenwayDirectService;

/**
 * This class stands for whoPays EnumType
 * @subpackage Enumerations
 */
class WhoPays
{
    /**
     * Constant for value 'DRIVER'
     * @return string 'DRIVER'
     */
    const VALUE_DRIVER = 'DRIVER';
    /**
     * Constant for value 'ACCOUNT'
     * @return string 'ACCOUNT'
     */
    const VALUE_ACCOUNT = 'ACCOUNT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRIVER
     * @uses self::VALUE_ACCOUNT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRIVER,
            self::VALUE_ACCOUNT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
