<?php

namespace GreenwayDirectService;

/**
 * This class stands for methodOfPayment EnumType
 * @subpackage Enumerations
 */
class MethodOfPayment
{
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'PC'
     * @return string 'PC'
     */
    const VALUE_PC = 'PC';
    /**
     * Constant for value 'EP'
     * @return string 'EP'
     */
    const VALUE_EP = 'EP';
    /**
     * Constant for value 'DEBC'
     * @return string 'DEBC'
     */
    const VALUE_DEBC = 'DEBC';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CC
     * @uses self::VALUE_PC
     * @uses self::VALUE_EP
     * @uses self::VALUE_DEBC
     * @uses self::VALUE_PO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CC,
            self::VALUE_PC,
            self::VALUE_EP,
            self::VALUE_DEBC,
            self::VALUE_PO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
