<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerReferenceType StructType
 * @subpackage Structs
 */
class CustomerReferenceType extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $value;
    /**
     * Constructor method for customerReferenceType
     * @uses CustomerReferenceType::setCode()
     * @uses CustomerReferenceType::setValue()
     * @param string $code
     * @param string $value
     */
    public function __construct($code = null, $value = null)
    {
        $this
            ->setCode($code)
            ->setValue($value);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \GreenwayDirectService\Code::valueIsValid()
     * @uses \GreenwayDirectService\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \GreenwayDirectService\CustomerReferenceType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \GreenwayDirectService\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \GreenwayDirectService\CustomerReferenceType
     */
    public function setValue($value = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($value) && strlen($value) > 50) || (is_array($value) && count($value) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($value) ? strlen($value) : count($value)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\CustomerReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
