<?php

namespace GreenwayDirectService;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'phoneNumberType' => '\\GreenwayDirectService\\PhoneNumberType',
            'rentalAddressType' => '\\GreenwayDirectService\\RentalAddressType',
            'whenAndWhereDetails' => '\\GreenwayDirectService\\WhenAndWhereDetails',
            'instructions' => '\\GreenwayDirectService\\Instructions',
            'authenticationType' => '\\GreenwayDirectService\\AuthenticationType',
            'errorType' => '\\GreenwayDirectService\\ErrorType',
            'licenceType' => '\\GreenwayDirectService\\LicenceType',
            'driverDetailsType' => '\\GreenwayDirectService\\DriverDetailsType',
            'driverType' => '\\GreenwayDirectService\\DriverType',
            'cardDetails' => '\\GreenwayDirectService\\CardDetails',
            'paymentType' => '\\GreenwayDirectService\\PaymentType',
            'customerReferenceType' => '\\GreenwayDirectService\\CustomerReferenceType',
            'chargeDetail' => '\\GreenwayDirectService\\ChargeDetail',
            'rates' => '\\GreenwayDirectService\\Rates',
            'specialCharges' => '\\GreenwayDirectService\\SpecialCharges',
            'equipmentDetail' => '\\GreenwayDirectService\\EquipmentDetail',
            'vehicleDetail' => '\\GreenwayDirectService\\VehicleDetail',
            'reservation' => '\\GreenwayDirectService\\Reservation',
            'cancelResDetail' => '\\GreenwayDirectService\\CancelResDetail',
            'fullRentalDetail' => '\\GreenwayDirectService\\FullRentalDetail',
            'offhireDetail' => '\\GreenwayDirectService\\OffhireDetail',
            'amendOffhire' => '\\GreenwayDirectService\\AmendOffhire',
            'amendOffhireResponse' => '\\GreenwayDirectService\\AmendOffhireResponse',
            'cancelReservation' => '\\GreenwayDirectService\\CancelReservation',
            'cancelReservationResponse' => '\\GreenwayDirectService\\CancelReservationResponse',
            'amendReservation' => '\\GreenwayDirectService\\AmendReservation',
            'amendReservationResponse' => '\\GreenwayDirectService\\AmendReservationResponse',
            'newReservation' => '\\GreenwayDirectService\\NewReservation',
            'newReservationResponse' => '\\GreenwayDirectService\\NewReservationResponse',
            'getQuote' => '\\GreenwayDirectService\\GetQuote',
            'checkoutRA' => '\\GreenwayDirectService\\CheckoutRA',
            'checkoutRAResponse' => '\\GreenwayDirectService\\CheckoutRAResponse',
            'checkinRA' => '\\GreenwayDirectService\\CheckinRA',
            'checkinRAResponse' => '\\GreenwayDirectService\\CheckinRAResponse',
            'amendRA' => '\\GreenwayDirectService\\AmendRA',
            'amendRAResponse' => '\\GreenwayDirectService\\AmendRAResponse',
            'cancelRA' => '\\GreenwayDirectService\\CancelRA',
            'cancelRAResponse' => '\\GreenwayDirectService\\CancelRAResponse',
        );
    }
}
