<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkout ServiceType
 * @subpackage Services
 */
class Checkout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkoutRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\CheckoutRA $parameters
     * @return \GreenwayDirectService\CheckoutRA|bool
     */
    public function checkoutRA(\GreenwayDirectService\CheckoutRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkoutRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\CheckoutRA
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
