<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\CancelReservation $parameters
     * @return \GreenwayDirectService\CancelReservationResponse|bool
     */
    public function cancelReservation(\GreenwayDirectService\CancelReservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cancelRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\CancelRA $parameters
     * @return \GreenwayDirectService\CancelRA|bool
     */
    public function cancelRA(\GreenwayDirectService\CancelRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->cancelRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\CancelRA|\GreenwayDirectService\CancelReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
