<?php

namespace GreenwayDirectService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for New ServiceType
 * @subpackage Services
 */
class _New extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named newReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\NewReservation $parameters
     * @return \GreenwayDirectService\NewReservationResponse|bool
     */
    public function newReservation(\GreenwayDirectService\NewReservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->newReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\NewReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
