<?php

namespace GreenwayDirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Amend ServiceType
 * @subpackage Services
 */
class Amend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named amendOffhire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\OffhireDetail $parameters
     * @return \GreenwayDirectService\StructType\OffhireDetail|bool
     */
    public function amendOffhire(\GreenwayDirectService\StructType\OffhireDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendOffhire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\Reservation $parameters
     * @return \GreenwayDirectService\StructType\Reservation|bool
     */
    public function amendReservation(\GreenwayDirectService\StructType\Reservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\AmendRA $parameters
     * @return \GreenwayDirectService\StructType\AmendRA|bool
     */
    public function amendRA(\GreenwayDirectService\StructType\AmendRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\StructType\AmendRA|\GreenwayDirectService\StructType\OffhireDetail|\GreenwayDirectService\StructType\Reservation
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
