<?php

namespace GreenwayDirectService\EnumType;

/**
 * This class stands for addressType EnumType
 * @subpackage Enumerations
 */
class AddressType
{
    /**
     * Constant for value 'HOME'
     * @return string 'HOME'
     */
    const VALUE_HOME = 'HOME';
    /**
     * Constant for value 'BUSINESS'
     * @return string 'BUSINESS'
     */
    const VALUE_BUSINESS = 'BUSINESS';
    /**
     * Constant for value 'WALKIN'
     * @return string 'WALKIN'
     */
    const VALUE_WALKIN = 'WALKIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOME
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_WALKIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOME,
            self::VALUE_BUSINESS,
            self::VALUE_WALKIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
