<?php

namespace FCSGreenway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driverType StructType
 * @subpackage Structs
 */
class DriverType extends AbstractStructBase
{
    /**
     * The primaryDriver
     * @var string
     */
    public $primaryDriver;
    /**
     * The driverId
     * @var int
     */
    public $driverId;
    /**
     * The driverDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \FCSGreenway\StructType\DriverDetailsType
     */
    public $driverDetails;
    /**
     * Constructor method for driverType
     * @uses DriverType::setPrimaryDriver()
     * @uses DriverType::setDriverId()
     * @uses DriverType::setDriverDetails()
     * @param string $primaryDriver
     * @param int $driverId
     * @param \FCSGreenway\StructType\DriverDetailsType $driverDetails
     */
    public function __construct($primaryDriver = null, $driverId = null, \FCSGreenway\StructType\DriverDetailsType $driverDetails = null)
    {
        $this
            ->setPrimaryDriver($primaryDriver)
            ->setDriverId($driverId)
            ->setDriverDetails($driverDetails);
    }
    /**
     * Get primaryDriver value
     * @return string|null
     */
    public function getPrimaryDriver()
    {
        return $this->primaryDriver;
    }
    /**
     * Set primaryDriver value
     * @uses \FCSGreenway\EnumType\YNFlag::valueIsValid()
     * @uses \FCSGreenway\EnumType\YNFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $primaryDriver
     * @return \FCSGreenway\StructType\DriverType
     */
    public function setPrimaryDriver($primaryDriver = null)
    {
        // validation for constraint: enumeration
        if (!\FCSGreenway\EnumType\YNFlag::valueIsValid($primaryDriver)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $primaryDriver, implode(', ', \FCSGreenway\EnumType\YNFlag::getValidValues())), __LINE__);
        }
        $this->primaryDriver = $primaryDriver;
        return $this;
    }
    /**
     * Get driverId value
     * @return int|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param int $driverId
     * @return \FCSGreenway\StructType\DriverType
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: int
        if (!is_null($driverId) && !is_numeric($driverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverId)), __LINE__);
        }
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get driverDetails value
     * @return \FCSGreenway\StructType\DriverDetailsType|null
     */
    public function getDriverDetails()
    {
        return $this->driverDetails;
    }
    /**
     * Set driverDetails value
     * @param \FCSGreenway\StructType\DriverDetailsType $driverDetails
     * @return \FCSGreenway\StructType\DriverType
     */
    public function setDriverDetails(\FCSGreenway\StructType\DriverDetailsType $driverDetails = null)
    {
        $this->driverDetails = $driverDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \FCSGreenway\StructType\DriverType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
