<?php

namespace FCSGreenway\EnumType;

/**
 * This class stands for rentalMessageType EnumType
 * @subpackage Enumerations
 */
class RentalMessageType
{
    /**
     * Constant for value 'CHECKOUT'
     * @return string 'CHECKOUT'
     */
    const VALUE_CHECKOUT = 'CHECKOUT';
    /**
     * Constant for value 'AMEND'
     * @return string 'AMEND'
     */
    const VALUE_AMEND = 'AMEND';
    /**
     * Constant for value 'CANCEL'
     * @return string 'CANCEL'
     */
    const VALUE_CANCEL = 'CANCEL';
    /**
     * Constant for value 'CHANGEOVER'
     * @return string 'CHANGEOVER'
     */
    const VALUE_CHANGEOVER = 'CHANGEOVER';
    /**
     * Constant for value 'BILLING'
     * @return string 'BILLING'
     */
    const VALUE_BILLING = 'BILLING';
    /**
     * Constant for value 'CHECKIN'
     * @return string 'CHECKIN'
     */
    const VALUE_CHECKIN = 'CHECKIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHECKOUT
     * @uses self::VALUE_AMEND
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_CHANGEOVER
     * @uses self::VALUE_BILLING
     * @uses self::VALUE_CHECKIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHECKOUT,
            self::VALUE_AMEND,
            self::VALUE_CANCEL,
            self::VALUE_CHANGEOVER,
            self::VALUE_BILLING,
            self::VALUE_CHECKIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
