<?php

namespace FCSGreenway;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'phoneNumberType' => '\\FCSGreenway\\StructType\\PhoneNumberType',
            'rentalAddressType' => '\\FCSGreenway\\StructType\\RentalAddressType',
            'whenAndWhereDetails' => '\\FCSGreenway\\StructType\\WhenAndWhereDetails',
            'instructions' => '\\FCSGreenway\\StructType\\Instructions',
            'authenticationType' => '\\FCSGreenway\\StructType\\AuthenticationType',
            'errorType' => '\\FCSGreenway\\StructType\\ErrorType',
            'licenceType' => '\\FCSGreenway\\StructType\\LicenceType',
            'driverDetailsType' => '\\FCSGreenway\\StructType\\DriverDetailsType',
            'driverType' => '\\FCSGreenway\\StructType\\DriverType',
            'cardDetails' => '\\FCSGreenway\\StructType\\CardDetails',
            'paymentType' => '\\FCSGreenway\\StructType\\PaymentType',
            'customerReferenceType' => '\\FCSGreenway\\StructType\\CustomerReferenceType',
            'chargeDetail' => '\\FCSGreenway\\StructType\\ChargeDetail',
            'rates' => '\\FCSGreenway\\StructType\\Rates',
            'specialCharges' => '\\FCSGreenway\\StructType\\SpecialCharges',
            'equipmentDetail' => '\\FCSGreenway\\StructType\\EquipmentDetail',
            'vehicleDetail' => '\\FCSGreenway\\StructType\\VehicleDetail',
            'fullResDetail' => '\\FCSGreenway\\StructType\\FullResDetail',
            'cancelResDetail' => '\\FCSGreenway\\StructType\\CancelResDetail',
            'fullRentalDetail' => '\\FCSGreenway\\StructType\\FullRentalDetail',
            'offhireDetail' => '\\FCSGreenway\\StructType\\OffhireDetail',
        );
    }
}
