<?php

namespace FCSGreenway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The methodOfPayment
     * @var string
     */
    public $methodOfPayment;
    /**
     * The creditOrDebitCard
     * @var \FCSGreenway\StructType\CardDetails
     */
    public $creditOrDebitCard;
    /**
     * The businessAccount
     * Meta informations extracted from the WSDL
     * - totalDigits: 8
     * @var int
     */
    public $businessAccount;
    /**
     * The chargeCard
     * Meta informations extracted from the WSDL
     * - whiteSpace: collapse
     * @var int
     */
    public $chargeCard;
    /**
     * Constructor method for paymentType
     * @uses PaymentType::setMethodOfPayment()
     * @uses PaymentType::setCreditOrDebitCard()
     * @uses PaymentType::setBusinessAccount()
     * @uses PaymentType::setChargeCard()
     * @param string $methodOfPayment
     * @param \FCSGreenway\StructType\CardDetails $creditOrDebitCard
     * @param int $businessAccount
     * @param int $chargeCard
     */
    public function __construct($methodOfPayment = null, \FCSGreenway\StructType\CardDetails $creditOrDebitCard = null, $businessAccount = null, $chargeCard = null)
    {
        $this
            ->setMethodOfPayment($methodOfPayment)
            ->setCreditOrDebitCard($creditOrDebitCard)
            ->setBusinessAccount($businessAccount)
            ->setChargeCard($chargeCard);
    }
    /**
     * Get methodOfPayment value
     * @return string|null
     */
    public function getMethodOfPayment()
    {
        return $this->methodOfPayment;
    }
    /**
     * Set methodOfPayment value
     * @uses \FCSGreenway\EnumType\MethodOfPayment::valueIsValid()
     * @uses \FCSGreenway\EnumType\MethodOfPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $methodOfPayment
     * @return \FCSGreenway\StructType\PaymentType
     */
    public function setMethodOfPayment($methodOfPayment = null)
    {
        // validation for constraint: enumeration
        if (!\FCSGreenway\EnumType\MethodOfPayment::valueIsValid($methodOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $methodOfPayment, implode(', ', \FCSGreenway\EnumType\MethodOfPayment::getValidValues())), __LINE__);
        }
        $this->methodOfPayment = $methodOfPayment;
        return $this;
    }
    /**
     * Get creditOrDebitCard value
     * @return \FCSGreenway\StructType\CardDetails|null
     */
    public function getCreditOrDebitCard()
    {
        return $this->creditOrDebitCard;
    }
    /**
     * Set creditOrDebitCard value
     * @param \FCSGreenway\StructType\CardDetails $creditOrDebitCard
     * @return \FCSGreenway\StructType\PaymentType
     */
    public function setCreditOrDebitCard(\FCSGreenway\StructType\CardDetails $creditOrDebitCard = null)
    {
        $this->creditOrDebitCard = $creditOrDebitCard;
        return $this;
    }
    /**
     * Get businessAccount value
     * @return int|null
     */
    public function getBusinessAccount()
    {
        return $this->businessAccount;
    }
    /**
     * Set businessAccount value
     * @param int $businessAccount
     * @return \FCSGreenway\StructType\PaymentType
     */
    public function setBusinessAccount($businessAccount = null)
    {
        // validation for constraint: totalDigits
        if (is_float($businessAccount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $businessAccount)) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 8 digits, "%d" given', strlen(substr($businessAccount, strpos($businessAccount, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($businessAccount) && !is_numeric($businessAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($businessAccount)), __LINE__);
        }
        $this->businessAccount = $businessAccount;
        return $this;
    }
    /**
     * Get chargeCard value
     * @return int|null
     */
    public function getChargeCard()
    {
        return $this->chargeCard;
    }
    /**
     * Set chargeCard value
     * @param int $chargeCard
     * @return \FCSGreenway\StructType\PaymentType
     */
    public function setChargeCard($chargeCard = null)
    {
        // validation for constraint: int
        if (!is_null($chargeCard) && !is_numeric($chargeCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeCard)), __LINE__);
        }
        $this->chargeCard = $chargeCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \FCSGreenway\StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
