<?php

namespace FCSGreenway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for chargeDetail StructType
 * @subpackage Structs
 */
class ChargeDetail extends AbstractStructBase
{
    /**
     * The chargeType
     * @var string
     */
    public $chargeType;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The unitsCharged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsCharged;
    /**
     * The chargeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $chargeRate;
    /**
     * The netCharge
     * @var float
     */
    public $netCharge;
    /**
     * The taxAmount
     * @var float
     */
    public $taxAmount;
    /**
     * The grossCharge
     * @var float
     */
    public $grossCharge;
    /**
     * The whoPays
     * @var string
     */
    public $whoPays;
    /**
     * The chargeDef
     * @var string
     */
    public $chargeDef;
    /**
     * The chargeTypeDesc
     * @var string
     */
    public $chargeTypeDesc;
    /**
     * The includedInCharge
     * @var string
     */
    public $includedInCharge;
    /**
     * The includedInChargeDesc
     * @var string
     */
    public $includedInChargeDesc;
    /**
     * The unitType
     * @var string
     */
    public $unitType;
    /**
     * The rate
     * @var string
     */
    public $rate;
    /**
     * The noOfUnits
     * @var string
     */
    public $noOfUnits;
    /**
     * The deposit
     * @var string
     */
    public $deposit;
    /**
     * The charge
     * @var string
     */
    public $charge;
    /**
     * The vatCode
     * @var string
     */
    public $vatCode;
    /**
     * The totalCharge
     * @var string
     */
    public $totalCharge;
    /**
     * The includeDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $includeDeposit;
    /**
     * The tpbAccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $tpbAccountNo;
    /**
     * Constructor method for chargeDetail
     * @uses ChargeDetail::setChargeType()
     * @uses ChargeDetail::setDescription()
     * @uses ChargeDetail::setUnitsCharged()
     * @uses ChargeDetail::setChargeRate()
     * @uses ChargeDetail::setNetCharge()
     * @uses ChargeDetail::setTaxAmount()
     * @uses ChargeDetail::setGrossCharge()
     * @uses ChargeDetail::setWhoPays()
     * @uses ChargeDetail::setChargeDef()
     * @uses ChargeDetail::setChargeTypeDesc()
     * @uses ChargeDetail::setIncludedInCharge()
     * @uses ChargeDetail::setIncludedInChargeDesc()
     * @uses ChargeDetail::setUnitType()
     * @uses ChargeDetail::setRate()
     * @uses ChargeDetail::setNoOfUnits()
     * @uses ChargeDetail::setDeposit()
     * @uses ChargeDetail::setCharge()
     * @uses ChargeDetail::setVatCode()
     * @uses ChargeDetail::setTotalCharge()
     * @uses ChargeDetail::setIncludeDeposit()
     * @uses ChargeDetail::setTpbAccountNo()
     * @param string $chargeType
     * @param string $description
     * @param int $unitsCharged
     * @param float $chargeRate
     * @param float $netCharge
     * @param float $taxAmount
     * @param float $grossCharge
     * @param string $whoPays
     * @param string $chargeDef
     * @param string $chargeTypeDesc
     * @param string $includedInCharge
     * @param string $includedInChargeDesc
     * @param string $unitType
     * @param string $rate
     * @param string $noOfUnits
     * @param string $deposit
     * @param string $charge
     * @param string $vatCode
     * @param string $totalCharge
     * @param string[] $includeDeposit
     * @param string[] $tpbAccountNo
     */
    public function __construct($chargeType = null, $description = null, $unitsCharged = null, $chargeRate = null, $netCharge = null, $taxAmount = null, $grossCharge = null, $whoPays = null, $chargeDef = null, $chargeTypeDesc = null, $includedInCharge = null, $includedInChargeDesc = null, $unitType = null, $rate = null, $noOfUnits = null, $deposit = null, $charge = null, $vatCode = null, $totalCharge = null, array $includeDeposit = array(), array $tpbAccountNo = array())
    {
        $this
            ->setChargeType($chargeType)
            ->setDescription($description)
            ->setUnitsCharged($unitsCharged)
            ->setChargeRate($chargeRate)
            ->setNetCharge($netCharge)
            ->setTaxAmount($taxAmount)
            ->setGrossCharge($grossCharge)
            ->setWhoPays($whoPays)
            ->setChargeDef($chargeDef)
            ->setChargeTypeDesc($chargeTypeDesc)
            ->setIncludedInCharge($includedInCharge)
            ->setIncludedInChargeDesc($includedInChargeDesc)
            ->setUnitType($unitType)
            ->setRate($rate)
            ->setNoOfUnits($noOfUnits)
            ->setDeposit($deposit)
            ->setCharge($charge)
            ->setVatCode($vatCode)
            ->setTotalCharge($totalCharge)
            ->setIncludeDeposit($includeDeposit)
            ->setTpbAccountNo($tpbAccountNo);
    }
    /**
     * Get chargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param string $chargeType
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeType)), __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get unitsCharged value
     * @return int|null
     */
    public function getUnitsCharged()
    {
        return $this->unitsCharged;
    }
    /**
     * Set unitsCharged value
     * @param int $unitsCharged
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setUnitsCharged($unitsCharged = null)
    {
        // validation for constraint: int
        if (!is_null($unitsCharged) && !is_numeric($unitsCharged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsCharged)), __LINE__);
        }
        $this->unitsCharged = $unitsCharged;
        return $this;
    }
    /**
     * Get chargeRate value
     * @return float|null
     */
    public function getChargeRate()
    {
        return $this->chargeRate;
    }
    /**
     * Set chargeRate value
     * @param float $chargeRate
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setChargeRate($chargeRate = null)
    {
        $this->chargeRate = $chargeRate;
        return $this;
    }
    /**
     * Get netCharge value
     * @return float|null
     */
    public function getNetCharge()
    {
        return $this->netCharge;
    }
    /**
     * Set netCharge value
     * @param float $netCharge
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setNetCharge($netCharge = null)
    {
        $this->netCharge = $netCharge;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get grossCharge value
     * @return float|null
     */
    public function getGrossCharge()
    {
        return $this->grossCharge;
    }
    /**
     * Set grossCharge value
     * @param float $grossCharge
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setGrossCharge($grossCharge = null)
    {
        $this->grossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get whoPays value
     * @return string|null
     */
    public function getWhoPays()
    {
        return $this->whoPays;
    }
    /**
     * Set whoPays value
     * @uses \FCSGreenway\EnumType\WhoPays::valueIsValid()
     * @uses \FCSGreenway\EnumType\WhoPays::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $whoPays
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setWhoPays($whoPays = null)
    {
        // validation for constraint: enumeration
        if (!\FCSGreenway\EnumType\WhoPays::valueIsValid($whoPays)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $whoPays, implode(', ', \FCSGreenway\EnumType\WhoPays::getValidValues())), __LINE__);
        }
        $this->whoPays = $whoPays;
        return $this;
    }
    /**
     * Get chargeDef value
     * @return string|null
     */
    public function getChargeDef()
    {
        return $this->chargeDef;
    }
    /**
     * Set chargeDef value
     * @param string $chargeDef
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setChargeDef($chargeDef = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDef) && !is_string($chargeDef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeDef)), __LINE__);
        }
        $this->chargeDef = $chargeDef;
        return $this;
    }
    /**
     * Get chargeTypeDesc value
     * @return string|null
     */
    public function getChargeTypeDesc()
    {
        return $this->chargeTypeDesc;
    }
    /**
     * Set chargeTypeDesc value
     * @param string $chargeTypeDesc
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setChargeTypeDesc($chargeTypeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($chargeTypeDesc) && !is_string($chargeTypeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeTypeDesc)), __LINE__);
        }
        $this->chargeTypeDesc = $chargeTypeDesc;
        return $this;
    }
    /**
     * Get includedInCharge value
     * @return string|null
     */
    public function getIncludedInCharge()
    {
        return $this->includedInCharge;
    }
    /**
     * Set includedInCharge value
     * @param string $includedInCharge
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setIncludedInCharge($includedInCharge = null)
    {
        // validation for constraint: string
        if (!is_null($includedInCharge) && !is_string($includedInCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includedInCharge)), __LINE__);
        }
        $this->includedInCharge = $includedInCharge;
        return $this;
    }
    /**
     * Get includedInChargeDesc value
     * @return string|null
     */
    public function getIncludedInChargeDesc()
    {
        return $this->includedInChargeDesc;
    }
    /**
     * Set includedInChargeDesc value
     * @param string $includedInChargeDesc
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setIncludedInChargeDesc($includedInChargeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($includedInChargeDesc) && !is_string($includedInChargeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includedInChargeDesc)), __LINE__);
        }
        $this->includedInChargeDesc = $includedInChargeDesc;
        return $this;
    }
    /**
     * Get unitType value
     * @return string|null
     */
    public function getUnitType()
    {
        return $this->unitType;
    }
    /**
     * Set unitType value
     * @param string $unitType
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setUnitType($unitType = null)
    {
        // validation for constraint: string
        if (!is_null($unitType) && !is_string($unitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitType)), __LINE__);
        }
        $this->unitType = $unitType;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get noOfUnits value
     * @return string|null
     */
    public function getNoOfUnits()
    {
        return $this->noOfUnits;
    }
    /**
     * Set noOfUnits value
     * @param string $noOfUnits
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setNoOfUnits($noOfUnits = null)
    {
        // validation for constraint: string
        if (!is_null($noOfUnits) && !is_string($noOfUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfUnits)), __LINE__);
        }
        $this->noOfUnits = $noOfUnits;
        return $this;
    }
    /**
     * Get deposit value
     * @return string|null
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param string $deposit
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: string
        if (!is_null($deposit) && !is_string($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deposit)), __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get charge value
     * @return string|null
     */
    public function getCharge()
    {
        return $this->charge;
    }
    /**
     * Set charge value
     * @param string $charge
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setCharge($charge = null)
    {
        // validation for constraint: string
        if (!is_null($charge) && !is_string($charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charge)), __LINE__);
        }
        $this->charge = $charge;
        return $this;
    }
    /**
     * Get vatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->vatCode;
    }
    /**
     * Set vatCode value
     * @param string $vatCode
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatCode)), __LINE__);
        }
        $this->vatCode = $vatCode;
        return $this;
    }
    /**
     * Get totalCharge value
     * @return string|null
     */
    public function getTotalCharge()
    {
        return $this->totalCharge;
    }
    /**
     * Set totalCharge value
     * @param string $totalCharge
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setTotalCharge($totalCharge = null)
    {
        // validation for constraint: string
        if (!is_null($totalCharge) && !is_string($totalCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalCharge)), __LINE__);
        }
        $this->totalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get includeDeposit value
     * @return string[]|null
     */
    public function getIncludeDeposit()
    {
        return $this->includeDeposit;
    }
    /**
     * Set includeDeposit value
     * @throws \InvalidArgumentException
     * @param string[] $includeDeposit
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setIncludeDeposit(array $includeDeposit = array())
    {
        foreach ($includeDeposit as $chargeDetailIncludeDepositItem) {
            // validation for constraint: itemType
            if (!is_string($chargeDetailIncludeDepositItem)) {
                throw new \InvalidArgumentException(sprintf('The includeDeposit property can only contain items of string, "%s" given', is_object($chargeDetailIncludeDepositItem) ? get_class($chargeDetailIncludeDepositItem) : gettype($chargeDetailIncludeDepositItem)), __LINE__);
            }
        }
        $this->includeDeposit = $includeDeposit;
        return $this;
    }
    /**
     * Add item to includeDeposit value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function addToIncludeDeposit($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The includeDeposit property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->includeDeposit[] = $item;
        return $this;
    }
    /**
     * Get tpbAccountNo value
     * @return string[]|null
     */
    public function getTpbAccountNo()
    {
        return $this->tpbAccountNo;
    }
    /**
     * Set tpbAccountNo value
     * @throws \InvalidArgumentException
     * @param string[] $tpbAccountNo
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function setTpbAccountNo(array $tpbAccountNo = array())
    {
        foreach ($tpbAccountNo as $chargeDetailTpbAccountNoItem) {
            // validation for constraint: itemType
            if (!is_string($chargeDetailTpbAccountNoItem)) {
                throw new \InvalidArgumentException(sprintf('The tpbAccountNo property can only contain items of string, "%s" given', is_object($chargeDetailTpbAccountNoItem) ? get_class($chargeDetailTpbAccountNoItem) : gettype($chargeDetailTpbAccountNoItem)), __LINE__);
            }
        }
        $this->tpbAccountNo = $tpbAccountNo;
        return $this;
    }
    /**
     * Add item to tpbAccountNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public function addToTpbAccountNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tpbAccountNo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tpbAccountNo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \FCSGreenway\StructType\ChargeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
