<?php

namespace GreenwayDirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkin ServiceType
 * @subpackage Services
 */
class Checkin extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkinRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\CheckinRA $parameters
     * @return \GreenwayDirectService\StructType\CheckinRA|bool
     */
    public function checkinRA(\GreenwayDirectService\StructType\CheckinRA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->checkinRA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\StructType\CheckinRA
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
