<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authenticationType StructType
 * @subpackage Structs
 */
class AuthenticationType extends AbstractStructBase
{
    /**
     * The siteCode
     * Meta informations extracted from the WSDL
     * - length: 3
     * @var string
     */
    public $siteCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * Constructor method for authenticationType
     * @uses AuthenticationType::setSiteCode()
     * @uses AuthenticationType::setPassword()
     * @param string $siteCode
     * @param string $password
     */
    public function __construct($siteCode = null, $password = null)
    {
        $this
            ->setSiteCode($siteCode)
            ->setPassword($password);
    }
    /**
     * Get siteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->siteCode;
    }
    /**
     * Set siteCode value
     * @param string $siteCode
     * @return \GreenwayDirectService\StructType\AuthenticationType
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($siteCode) && strlen($siteCode) !== 3) || (is_array($siteCode) && count($siteCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteCode)), __LINE__);
        }
        $this->siteCode = $siteCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \GreenwayDirectService\StructType\AuthenticationType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\AuthenticationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
