<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vehicleDetail StructType
 * @subpackage Structs
 */
class VehicleDetail extends AbstractStructBase
{
    /**
     * The registrationNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 10
     * @var string
     */
    public $registrationNumber;
    /**
     * The suppliedModel
     * @var acrissCode
     */
    public $suppliedModel;
    /**
     * The outDate
     * Meta informations extracted from the WSDL
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $outDate;
    /**
     * The outTime
     * Meta informations extracted from the WSDL
     * - length: 5
     * - pattern: [0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}
     * @var string
     */
    public $outTime;
    /**
     * The outOdometer
     * @var int
     */
    public $outOdometer;
    /**
     * The inOdometer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inOdometer;
    /**
     * The inDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $inDate;
    /**
     * The inTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}
     * @var string
     */
    public $inTime;
    /**
     * The modelDescription
     * @var string
     */
    public $modelDescription;
    /**
     * The registrationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - length: 10
     * - pattern: [0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}
     * @var string
     */
    public $registrationDate;
    /**
     * The transmission
     * @var string
     */
    public $transmission;
    /**
     * The CO2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CO2;
    /**
     * The engineSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $engineSize;
    /**
     * The P11DValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $P11DValue;
    /**
     * The fuelType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fuelType;
    /**
     * Constructor method for vehicleDetail
     * @uses VehicleDetail::setRegistrationNumber()
     * @uses VehicleDetail::setSuppliedModel()
     * @uses VehicleDetail::setOutDate()
     * @uses VehicleDetail::setOutTime()
     * @uses VehicleDetail::setOutOdometer()
     * @uses VehicleDetail::setInOdometer()
     * @uses VehicleDetail::setInDate()
     * @uses VehicleDetail::setInTime()
     * @uses VehicleDetail::setModelDescription()
     * @uses VehicleDetail::setRegistrationDate()
     * @uses VehicleDetail::setTransmission()
     * @uses VehicleDetail::setCO2()
     * @uses VehicleDetail::setEngineSize()
     * @uses VehicleDetail::setP11DValue()
     * @uses VehicleDetail::setFuelType()
     * @param string $registrationNumber
     * @param acrissCode $suppliedModel
     * @param string $outDate
     * @param string $outTime
     * @param int $outOdometer
     * @param int $inOdometer
     * @param string $inDate
     * @param string $inTime
     * @param string $modelDescription
     * @param string $registrationDate
     * @param string $transmission
     * @param float $cO2
     * @param int $engineSize
     * @param float $p11DValue
     * @param string $fuelType
     */
    public function __construct($registrationNumber = null, acrissCode $suppliedModel = null, $outDate = null, $outTime = null, $outOdometer = null, $inOdometer = null, $inDate = null, $inTime = null, $modelDescription = null, $registrationDate = null, $transmission = null, $cO2 = null, $engineSize = null, $p11DValue = null, $fuelType = null)
    {
        $this
            ->setRegistrationNumber($registrationNumber)
            ->setSuppliedModel($suppliedModel)
            ->setOutDate($outDate)
            ->setOutTime($outTime)
            ->setOutOdometer($outOdometer)
            ->setInOdometer($inOdometer)
            ->setInDate($inDate)
            ->setInTime($inTime)
            ->setModelDescription($modelDescription)
            ->setRegistrationDate($registrationDate)
            ->setTransmission($transmission)
            ->setCO2($cO2)
            ->setEngineSize($engineSize)
            ->setP11DValue($p11DValue)
            ->setFuelType($fuelType);
    }
    /**
     * Get registrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->registrationNumber;
    }
    /**
     * Set registrationNumber value
     * @param string $registrationNumber
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationNumber) && strlen($registrationNumber) > 10) || (is_array($registrationNumber) && count($registrationNumber) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($registrationNumber) ? strlen($registrationNumber) : count($registrationNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationNumber)), __LINE__);
        }
        $this->registrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get suppliedModel value
     * @return acrissCode|null
     */
    public function getSuppliedModel()
    {
        return $this->suppliedModel;
    }
    /**
     * Set suppliedModel value
     * @param acrissCode $suppliedModel
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setSuppliedModel(acrissCode $suppliedModel = null)
    {
        $this->suppliedModel = $suppliedModel;
        return $this;
    }
    /**
     * Get outDate value
     * @return string|null
     */
    public function getOutDate()
    {
        return $this->outDate;
    }
    /**
     * Set outDate value
     * @param string $outDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutDate($outDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($outDate) && strlen($outDate) !== 10) || (is_array($outDate) && count($outDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($outDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $outDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($outDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($outDate) && !is_string($outDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outDate)), __LINE__);
        }
        $this->outDate = $outDate;
        return $this;
    }
    /**
     * Get outTime value
     * @return string|null
     */
    public function getOutTime()
    {
        return $this->outTime;
    }
    /**
     * Set outTime value
     * @param string $outTime
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutTime($outTime = null)
    {
        // validation for constraint: length
        if ((is_scalar($outTime) && strlen($outTime) !== 5) || (is_array($outTime) && count($outTime) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($outTime) && !preg_match('/[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}/', $outTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}", "%s" given', var_export($outTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($outTime) && !is_string($outTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outTime)), __LINE__);
        }
        $this->outTime = $outTime;
        return $this;
    }
    /**
     * Get outOdometer value
     * @return int|null
     */
    public function getOutOdometer()
    {
        return $this->outOdometer;
    }
    /**
     * Set outOdometer value
     * @param int $outOdometer
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutOdometer($outOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($outOdometer) && !is_numeric($outOdometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outOdometer)), __LINE__);
        }
        $this->outOdometer = $outOdometer;
        return $this;
    }
    /**
     * Get inOdometer value
     * @return int|null
     */
    public function getInOdometer()
    {
        return $this->inOdometer;
    }
    /**
     * Set inOdometer value
     * @param int $inOdometer
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInOdometer($inOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($inOdometer) && !is_numeric($inOdometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inOdometer)), __LINE__);
        }
        $this->inOdometer = $inOdometer;
        return $this;
    }
    /**
     * Get inDate value
     * @return string|null
     */
    public function getInDate()
    {
        return $this->inDate;
    }
    /**
     * Set inDate value
     * @param string $inDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInDate($inDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($inDate) && strlen($inDate) !== 10) || (is_array($inDate) && count($inDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($inDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $inDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($inDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inDate) && !is_string($inDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inDate)), __LINE__);
        }
        $this->inDate = $inDate;
        return $this;
    }
    /**
     * Get inTime value
     * @return string|null
     */
    public function getInTime()
    {
        return $this->inTime;
    }
    /**
     * Set inTime value
     * @param string $inTime
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInTime($inTime = null)
    {
        // validation for constraint: length
        if ((is_scalar($inTime) && strlen($inTime) !== 5) || (is_array($inTime) && count($inTime) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($inTime) && !preg_match('/[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}/', $inTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-2]{1}[0-9]{1}[:]{1}[0-5]{1}[0-9]{1}", "%s" given', var_export($inTime, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inTime) && !is_string($inTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inTime)), __LINE__);
        }
        $this->inTime = $inTime;
        return $this;
    }
    /**
     * Get modelDescription value
     * @return string|null
     */
    public function getModelDescription()
    {
        return $this->modelDescription;
    }
    /**
     * Set modelDescription value
     * @param string $modelDescription
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setModelDescription($modelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($modelDescription) && !is_string($modelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelDescription)), __LINE__);
        }
        $this->modelDescription = $modelDescription;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: length
        if ((is_scalar($registrationDate) && strlen($registrationDate) !== 10) || (is_array($registrationDate) && count($registrationDate) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($registrationDate) && !preg_match('/[0-3]{1}[0-9]{1}[\/]{1}[0-1]{1}[0-9]{1}[\/][0-9]{4}/', $registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-3]{1}[0-9]{1}[/]{1}[0-1]{1}[0-9]{1}[/][0-9]{4}", "%s" given', var_export($registrationDate, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get transmission value
     * @return string|null
     */
    public function getTransmission()
    {
        return $this->transmission;
    }
    /**
     * Set transmission value
     * @param string $transmission
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setTransmission($transmission = null)
    {
        // validation for constraint: string
        if (!is_null($transmission) && !is_string($transmission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmission)), __LINE__);
        }
        $this->transmission = $transmission;
        return $this;
    }
    /**
     * Get CO2 value
     * @return float|null
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param float $cO2
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setCO2($cO2 = null)
    {
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get engineSize value
     * @return int|null
     */
    public function getEngineSize()
    {
        return $this->engineSize;
    }
    /**
     * Set engineSize value
     * @param int $engineSize
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setEngineSize($engineSize = null)
    {
        // validation for constraint: int
        if (!is_null($engineSize) && !is_numeric($engineSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($engineSize)), __LINE__);
        }
        $this->engineSize = $engineSize;
        return $this;
    }
    /**
     * Get P11DValue value
     * @return float|null
     */
    public function getP11DValue()
    {
        return $this->P11DValue;
    }
    /**
     * Set P11DValue value
     * @param float $p11DValue
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setP11DValue($p11DValue = null)
    {
        $this->P11DValue = $p11DValue;
        return $this;
    }
    /**
     * Get fuelType value
     * @return string|null
     */
    public function getFuelType()
    {
        return $this->fuelType;
    }
    /**
     * Set fuelType value
     * @uses \GreenwayDirectService\EnumType\FuelType::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\FuelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fuelType
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\FuelType::valueIsValid($fuelType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fuelType, implode(', ', \GreenwayDirectService\EnumType\FuelType::getValidValues())), __LINE__);
        }
        $this->fuelType = $fuelType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
