<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fullResDetail StructType
 * @subpackage Structs
 */
class FullResDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayDirectService\StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reservationNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - totalDigits: 8
     * @var int
     */
    public $contractId;
    /**
     * The modelRequested
     * @var acrissCode
     */
    public $modelRequested;
    /**
     * The contactTelNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $contactTelNo;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 25
     * @var string
     */
    public $contactName;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $start;
    /**
     * The end
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * @var \GreenwayDirectService\StructType\DriverType[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\PaymentType[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 13
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\CustomerReferenceType[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $note;
    /**
     * The equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\EquipmentDetail[]
     */
    public $equipment;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\ChargeDetail[]
     */
    public $charges;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\ErrorType[]
     */
    public $error;
    /**
     * Constructor method for fullResDetail
     * @uses FullResDetail::setAuthentication()
     * @uses FullResDetail::setReservationNumber()
     * @uses FullResDetail::setStatus()
     * @uses FullResDetail::setContractId()
     * @uses FullResDetail::setModelRequested()
     * @uses FullResDetail::setContactTelNo()
     * @uses FullResDetail::setContactName()
     * @uses FullResDetail::setIataNumber()
     * @uses FullResDetail::setFlightNumber()
     * @uses FullResDetail::setStart()
     * @uses FullResDetail::setEnd()
     * @uses FullResDetail::setDriver()
     * @uses FullResDetail::setPayment()
     * @uses FullResDetail::setCustomerReference()
     * @uses FullResDetail::setNote()
     * @uses FullResDetail::setEquipment()
     * @uses FullResDetail::setCharges()
     * @uses FullResDetail::setError()
     * @param \GreenwayDirectService\StructType\AuthenticationType $authentication
     * @param int $reservationNumber
     * @param string $status
     * @param int $contractId
     * @param acrissCode $modelRequested
     * @param string $contactTelNo
     * @param string $contactName
     * @param string $iataNumber
     * @param string $flightNumber
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @param \GreenwayDirectService\StructType\DriverType[] $driver
     * @param \GreenwayDirectService\StructType\PaymentType[] $payment
     * @param \GreenwayDirectService\StructType\CustomerReferenceType[] $customerReference
     * @param string[] $note
     * @param \GreenwayDirectService\StructType\EquipmentDetail[] $equipment
     * @param \GreenwayDirectService\StructType\ChargeDetail[] $charges
     * @param \GreenwayDirectService\StructType\ErrorType[] $error
     */
    public function __construct(\GreenwayDirectService\StructType\AuthenticationType $authentication = null, $reservationNumber = null, $status = null, $contractId = null, acrissCode $modelRequested = null, $contactTelNo = null, $contactName = null, $iataNumber = null, $flightNumber = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $start = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $equipment = array(), array $charges = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setStatus($status)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setContactTelNo($contactTelNo)
            ->setContactName($contactName)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setEquipment($equipment)
            ->setCharges($charges)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\StructType\AuthenticationType|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\StructType\AuthenticationType $authentication
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setAuthentication(\GreenwayDirectService\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \GreenwayDirectService\EnumType\StatusCodeType::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\StatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\StatusCodeType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \GreenwayDirectService\EnumType\StatusCodeType::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get contractId value
     * @return int|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param int $contractId
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($contractId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $contractId)) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 8 digits, "%d" given', strlen(substr($contractId, strpos($contractId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($contractId) && !is_numeric($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return acrissCode|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param acrissCode $modelRequested
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setModelRequested(acrissCode $modelRequested = null)
    {
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get contactTelNo value
     * @return string|null
     */
    public function getContactTelNo()
    {
        return $this->contactTelNo;
    }
    /**
     * Set contactTelNo value
     * @param string $contactTelNo
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContactTelNo($contactTelNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactTelNo) && strlen($contactTelNo) > 15) || (is_array($contactTelNo) && count($contactTelNo) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($contactTelNo) ? strlen($contactTelNo) : count($contactTelNo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactTelNo) && !is_string($contactTelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTelNo)), __LINE__);
        }
        $this->contactTelNo = $contactTelNo;
        return $this;
    }
    /**
     * Get contactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->contactName;
    }
    /**
     * Set contactName value
     * @param string $contactName
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactName) && strlen($contactName) > 25) || (is_array($contactName) && count($contactName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($contactName) ? strlen($contactName) : count($contactName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->contactName = $contactName;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setStart(\GreenwayDirectService\StructType\WhenAndWhereDetails $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setEnd(\GreenwayDirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return \GreenwayDirectService\StructType\DriverType[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\DriverType[] $driver
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $fullResDetailDriverItem) {
            // validation for constraint: itemType
            if (!$fullResDetailDriverItem instanceof \GreenwayDirectService\StructType\DriverType) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayDirectService\StructType\DriverType, "%s" given', is_object($fullResDetailDriverItem) ? get_class($fullResDetailDriverItem) : gettype($fullResDetailDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\DriverType $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToDriver(\GreenwayDirectService\StructType\DriverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\DriverType) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayDirectService\StructType\DriverType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * @return \GreenwayDirectService\StructType\PaymentType[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\PaymentType[] $payment
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $fullResDetailPaymentItem) {
            // validation for constraint: itemType
            if (!$fullResDetailPaymentItem instanceof \GreenwayDirectService\StructType\PaymentType) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayDirectService\StructType\PaymentType, "%s" given', is_object($fullResDetailPaymentItem) ? get_class($fullResDetailPaymentItem) : gettype($fullResDetailPaymentItem)), __LINE__);
            }
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\PaymentType $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToPayment(\GreenwayDirectService\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayDirectService\StructType\PaymentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * @return \GreenwayDirectService\StructType\CustomerReferenceType[]|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\CustomerReferenceType[] $customerReference
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $fullResDetailCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!$fullResDetailCustomerReferenceItem instanceof \GreenwayDirectService\StructType\CustomerReferenceType) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayDirectService\StructType\CustomerReferenceType, "%s" given', is_object($fullResDetailCustomerReferenceItem) ? get_class($fullResDetailCustomerReferenceItem) : gettype($fullResDetailCustomerReferenceItem)), __LINE__);
            }
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\CustomerReferenceType $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToCustomerReference(\GreenwayDirectService\StructType\CustomerReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\CustomerReferenceType) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayDirectService\StructType\CustomerReferenceType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * @return string[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($note) && strlen($note) > 50) || (is_array($note) && count($note) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($note) ? strlen($note) : count($note)), __LINE__);
        }
        foreach ($note as $fullResDetailNoteItem) {
            // validation for constraint: itemType
            if (!is_string($fullResDetailNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($fullResDetailNoteItem) ? get_class($fullResDetailNoteItem) : gettype($fullResDetailNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get equipment value
     * @return \GreenwayDirectService\StructType\EquipmentDetail[]|null
     */
    public function getEquipment()
    {
        return $this->equipment;
    }
    /**
     * Set equipment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\EquipmentDetail[] $equipment
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $fullResDetailEquipmentItem) {
            // validation for constraint: itemType
            if (!$fullResDetailEquipmentItem instanceof \GreenwayDirectService\StructType\EquipmentDetail) {
                throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayDirectService\StructType\EquipmentDetail, "%s" given', is_object($fullResDetailEquipmentItem) ? get_class($fullResDetailEquipmentItem) : gettype($fullResDetailEquipmentItem)), __LINE__);
            }
        }
        $this->equipment = $equipment;
        return $this;
    }
    /**
     * Add item to equipment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\EquipmentDetail $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToEquipment(\GreenwayDirectService\StructType\EquipmentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\EquipmentDetail) {
            throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayDirectService\StructType\EquipmentDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->equipment[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * @return \GreenwayDirectService\StructType\ChargeDetail[]|null
     */
    public function getCharges()
    {
        return $this->charges;
    }
    /**
     * Set charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ChargeDetail[] $charges
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $fullResDetailChargesItem) {
            // validation for constraint: itemType
            if (!$fullResDetailChargesItem instanceof \GreenwayDirectService\StructType\ChargeDetail) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayDirectService\StructType\ChargeDetail, "%s" given', is_object($fullResDetailChargesItem) ? get_class($fullResDetailChargesItem) : gettype($fullResDetailChargesItem)), __LINE__);
            }
        }
        $this->charges = $charges;
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ChargeDetail $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToCharges(\GreenwayDirectService\StructType\ChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayDirectService\StructType\ChargeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayDirectService\StructType\ErrorType[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ErrorType[] $error
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $fullResDetailErrorItem) {
            // validation for constraint: itemType
            if (!$fullResDetailErrorItem instanceof \GreenwayDirectService\StructType\ErrorType) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ErrorType, "%s" given', is_object($fullResDetailErrorItem) ? get_class($fullResDetailErrorItem) : gettype($fullResDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ErrorType $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToError(\GreenwayDirectService\StructType\ErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ErrorType) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
