<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The methodOfPayment
     * @var string
     */
    public $methodOfPayment;
    /**
     * The creditOrDebitCard
     * @var mixed
     */
    public $creditOrDebitCard;
    /**
     * The businessAccount
     * @var mixed
     */
    public $businessAccount;
    /**
     * The chargeCard
     * @var mixed
     */
    public $chargeCard;
    /**
     * Constructor method for paymentType
     * @uses PaymentType::setMethodOfPayment()
     * @uses PaymentType::setCreditOrDebitCard()
     * @uses PaymentType::setBusinessAccount()
     * @uses PaymentType::setChargeCard()
     * @param string $methodOfPayment
     * @param mixed $creditOrDebitCard
     * @param mixed $businessAccount
     * @param mixed $chargeCard
     */
    public function __construct($methodOfPayment = null, $creditOrDebitCard = null, $businessAccount = null, $chargeCard = null)
    {
        $this
            ->setMethodOfPayment($methodOfPayment)
            ->setCreditOrDebitCard($creditOrDebitCard)
            ->setBusinessAccount($businessAccount)
            ->setChargeCard($chargeCard);
    }
    /**
     * Get methodOfPayment value
     * @return string|null
     */
    public function getMethodOfPayment()
    {
        return $this->methodOfPayment;
    }
    /**
     * Set methodOfPayment value
     * @uses \GreenwayDirectService\EnumType\MethodOfPayment::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\MethodOfPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $methodOfPayment
     * @return \GreenwayDirectService\StructType\PaymentType
     */
    public function setMethodOfPayment($methodOfPayment = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\MethodOfPayment::valueIsValid($methodOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $methodOfPayment, implode(', ', \GreenwayDirectService\EnumType\MethodOfPayment::getValidValues())), __LINE__);
        }
        $this->methodOfPayment = $methodOfPayment;
        return $this;
    }
    /**
     * Get creditOrDebitCard value
     * @return mixed|null
     */
    public function getCreditOrDebitCard()
    {
        return $this->creditOrDebitCard;
    }
    /**
     * Set creditOrDebitCard value
     * @param mixed $creditOrDebitCard
     * @return \GreenwayDirectService\StructType\PaymentType
     */
    public function setCreditOrDebitCard($creditOrDebitCard = null)
    {
        $this->creditOrDebitCard = $creditOrDebitCard;
        return $this;
    }
    /**
     * Get businessAccount value
     * @return mixed|null
     */
    public function getBusinessAccount()
    {
        return $this->businessAccount;
    }
    /**
     * Set businessAccount value
     * @param mixed $businessAccount
     * @return \GreenwayDirectService\StructType\PaymentType
     */
    public function setBusinessAccount($businessAccount = null)
    {
        $this->businessAccount = $businessAccount;
        return $this;
    }
    /**
     * Get chargeCard value
     * @return mixed|null
     */
    public function getChargeCard()
    {
        return $this->chargeCard;
    }
    /**
     * Set chargeCard value
     * @param mixed $chargeCard
     * @return \GreenwayDirectService\StructType\PaymentType
     */
    public function setChargeCard($chargeCard = null)
    {
        $this->chargeCard = $chargeCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\PaymentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
