<?php

namespace GreenwayDirectService;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'phoneNumberType' => '\\GreenwayDirectService\\StructType\\PhoneNumberType',
            'rentalAddressType' => '\\GreenwayDirectService\\StructType\\RentalAddressType',
            'whenAndWhereDetails' => '\\GreenwayDirectService\\StructType\\WhenAndWhereDetails',
            'instructions' => '\\GreenwayDirectService\\StructType\\Instructions',
            'authenticationType' => '\\GreenwayDirectService\\StructType\\AuthenticationType',
            'errorType' => '\\GreenwayDirectService\\StructType\\ErrorType',
            'licenceType' => '\\GreenwayDirectService\\StructType\\LicenceType',
            'driverDetailsType' => '\\GreenwayDirectService\\StructType\\DriverDetailsType',
            'driverType' => '\\GreenwayDirectService\\StructType\\DriverType',
            'cardDetails' => '\\GreenwayDirectService\\StructType\\CardDetails',
            'paymentType' => '\\GreenwayDirectService\\StructType\\PaymentType',
            'customerReferenceType' => '\\GreenwayDirectService\\StructType\\CustomerReferenceType',
            'chargeDetail' => '\\GreenwayDirectService\\StructType\\ChargeDetail',
            'rates' => '\\GreenwayDirectService\\StructType\\Rates',
            'specialCharges' => '\\GreenwayDirectService\\StructType\\SpecialCharges',
            'equipmentDetail' => '\\GreenwayDirectService\\StructType\\EquipmentDetail',
            'vehicleDetail' => '\\GreenwayDirectService\\StructType\\VehicleDetail',
            'fullResDetail' => '\\GreenwayDirectService\\StructType\\FullResDetail',
            'cancelResDetail' => '\\GreenwayDirectService\\StructType\\CancelResDetail',
            'fullRentalDetail' => '\\GreenwayDirectService\\StructType\\FullRentalDetail',
            'offhireDetail' => '\\GreenwayDirectService\\StructType\\OffhireDetail',
            'newReservation' => '\\GreenwayDirectService\\StructType\\NewReservation',
            'newReservationResponse' => '\\GreenwayDirectService\\StructType\\NewReservationResponse',
        );
    }
}
