<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for licenceType StructType
 * @subpackage Structs
 */
class LicenceType extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The issueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $issueDate;
    /**
     * The expiryDate
     * @var mixed
     */
    public $expiryDate;
    /**
     * The issuingCity
     * @var mixed
     */
    public $issuingCity;
    /**
     * The issuingCountry
     * @var mixed
     */
    public $issuingCountry;
    /**
     * Constructor method for licenceType
     * @uses LicenceType::setNumber()
     * @uses LicenceType::setIssueDate()
     * @uses LicenceType::setExpiryDate()
     * @uses LicenceType::setIssuingCity()
     * @uses LicenceType::setIssuingCountry()
     * @param string $number
     * @param mixed $issueDate
     * @param mixed $expiryDate
     * @param mixed $issuingCity
     * @param mixed $issuingCountry
     */
    public function __construct($number = null, $issueDate = null, $expiryDate = null, $issuingCity = null, $issuingCountry = null)
    {
        $this
            ->setNumber($number)
            ->setIssueDate($issueDate)
            ->setExpiryDate($expiryDate)
            ->setIssuingCity($issuingCity)
            ->setIssuingCountry($issuingCountry);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get issueDate value
     * @return mixed|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param mixed $issueDate
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public function setIssueDate($issueDate = null)
    {
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return mixed|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param mixed $expiryDate
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public function setExpiryDate($expiryDate = null)
    {
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get issuingCity value
     * @return mixed|null
     */
    public function getIssuingCity()
    {
        return $this->issuingCity;
    }
    /**
     * Set issuingCity value
     * @param mixed $issuingCity
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public function setIssuingCity($issuingCity = null)
    {
        $this->issuingCity = $issuingCity;
        return $this;
    }
    /**
     * Get issuingCountry value
     * @return mixed|null
     */
    public function getIssuingCountry()
    {
        return $this->issuingCountry;
    }
    /**
     * Set issuingCountry value
     * @param mixed $issuingCountry
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public function setIssuingCountry($issuingCountry = null)
    {
        $this->issuingCountry = $issuingCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\LicenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
