<?php

namespace GreenwayDirectService\EnumType;

/**
 * This class stands for cardType EnumType
 * @subpackage Enumerations
 */
class CardType
{
    /**
     * Constant for value 'SO'
     * @return string 'SO'
     */
    const VALUE_SO = 'SO';
    /**
     * Constant for value 'SW'
     * @return string 'SW'
     */
    const VALUE_SW = 'SW';
    /**
     * Constant for value 'VI'
     * @return string 'VI'
     */
    const VALUE_VI = 'VI';
    /**
     * Constant for value 'AX'
     * @return string 'AX'
     */
    const VALUE_AX = 'AX';
    /**
     * Constant for value 'MC'
     * @return string 'MC'
     */
    const VALUE_MC = 'MC';
    /**
     * Constant for value 'DC'
     * @return string 'DC'
     */
    const VALUE_DC = 'DC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SO
     * @uses self::VALUE_SW
     * @uses self::VALUE_VI
     * @uses self::VALUE_AX
     * @uses self::VALUE_MC
     * @uses self::VALUE_DC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SO,
            self::VALUE_SW,
            self::VALUE_VI,
            self::VALUE_AX,
            self::VALUE_MC,
            self::VALUE_DC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
