<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fullRentalDetail StructType
 * @subpackage Structs
 */
class FullRentalDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The rentalUpdateType
     * @var mixed
     */
    public $rentalUpdateType;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The contractId
     * @var mixed
     */
    public $contractId;
    /**
     * The modelRequested
     * @var mixed
     */
    public $modelRequested;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var mixed
     */
    public $start;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 6
     * @var mixed[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 13
     * - minOccurs: 0
     * @var mixed[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $note;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $charges;
    /**
     * The vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $vehicle;
    /**
     * The lastBillingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $lastBillingDate;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $error;
    /**
     * Constructor method for fullRentalDetail
     * @uses FullRentalDetail::setAuthentication()
     * @uses FullRentalDetail::setRentalNumber()
     * @uses FullRentalDetail::setRentalUpdateType()
     * @uses FullRentalDetail::setReservationNumber()
     * @uses FullRentalDetail::setContractId()
     * @uses FullRentalDetail::setModelRequested()
     * @uses FullRentalDetail::setIataNumber()
     * @uses FullRentalDetail::setFlightNumber()
     * @uses FullRentalDetail::setStart()
     * @uses FullRentalDetail::setEnd()
     * @uses FullRentalDetail::setDriver()
     * @uses FullRentalDetail::setPayment()
     * @uses FullRentalDetail::setCustomerReference()
     * @uses FullRentalDetail::setNote()
     * @uses FullRentalDetail::setCharges()
     * @uses FullRentalDetail::setVehicle()
     * @uses FullRentalDetail::setLastBillingDate()
     * @uses FullRentalDetail::setError()
     * @param mixed $authentication
     * @param int $rentalNumber
     * @param mixed $rentalUpdateType
     * @param int $reservationNumber
     * @param mixed $contractId
     * @param mixed $modelRequested
     * @param string $iataNumber
     * @param string $flightNumber
     * @param mixed $start
     * @param mixed $end
     * @param mixed[] $driver
     * @param mixed[] $payment
     * @param mixed[] $customerReference
     * @param mixed[] $note
     * @param mixed[] $charges
     * @param mixed[] $vehicle
     * @param mixed $lastBillingDate
     * @param mixed[] $error
     */
    public function __construct($authentication = null, $rentalNumber = null, $rentalUpdateType = null, $reservationNumber = null, $contractId = null, $modelRequested = null, $iataNumber = null, $flightNumber = null, $start = null, $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $charges = array(), array $vehicle = array(), $lastBillingDate = null, array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setRentalNumber($rentalNumber)
            ->setRentalUpdateType($rentalUpdateType)
            ->setReservationNumber($reservationNumber)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setCharges($charges)
            ->setVehicle($vehicle)
            ->setLastBillingDate($lastBillingDate)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get rentalUpdateType value
     * @return mixed|null
     */
    public function getRentalUpdateType()
    {
        return $this->rentalUpdateType;
    }
    /**
     * Set rentalUpdateType value
     * @param mixed $rentalUpdateType
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setRentalUpdateType($rentalUpdateType = null)
    {
        $this->rentalUpdateType = $rentalUpdateType;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get contractId value
     * @return mixed|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param mixed $contractId
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setContractId($contractId = null)
    {
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return mixed|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param mixed $modelRequested
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setModelRequested($modelRequested = null)
    {
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return mixed|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param mixed $start
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return mixed[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param mixed[] $driver
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $fullRentalDetailDriverItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of anyType, "%s" given', is_object($fullRentalDetailDriverItem) ? get_class($fullRentalDetailDriverItem) : gettype($fullRentalDetailDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToDriver($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * @return mixed[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @throws \InvalidArgumentException
     * @param mixed[] $payment
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $fullRentalDetailPaymentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of anyType, "%s" given', is_object($fullRentalDetailPaymentItem) ? get_class($fullRentalDetailPaymentItem) : gettype($fullRentalDetailPaymentItem)), __LINE__);
            }
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToPayment($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * @return mixed[]|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @throws \InvalidArgumentException
     * @param mixed[] $customerReference
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $fullRentalDetailCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of anyType, "%s" given', is_object($fullRentalDetailCustomerReferenceItem) ? get_class($fullRentalDetailCustomerReferenceItem) : gettype($fullRentalDetailCustomerReferenceItem)), __LINE__);
            }
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToCustomerReference($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * @return mixed[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param mixed[] $note
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $fullRentalDetailNoteItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($fullRentalDetailNoteItem) ? get_class($fullRentalDetailNoteItem) : gettype($fullRentalDetailNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * @return mixed[]|null
     */
    public function getCharges()
    {
        return $this->charges;
    }
    /**
     * Set charges value
     * @throws \InvalidArgumentException
     * @param mixed[] $charges
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $fullRentalDetailChargesItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of anyType, "%s" given', is_object($fullRentalDetailChargesItem) ? get_class($fullRentalDetailChargesItem) : gettype($fullRentalDetailChargesItem)), __LINE__);
            }
        }
        $this->charges = $charges;
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToCharges($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get vehicle value
     * @return mixed[]|null
     */
    public function getVehicle()
    {
        return $this->vehicle;
    }
    /**
     * Set vehicle value
     * @throws \InvalidArgumentException
     * @param mixed[] $vehicle
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setVehicle(array $vehicle = array())
    {
        foreach ($vehicle as $fullRentalDetailVehicleItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The vehicle property can only contain items of anyType, "%s" given', is_object($fullRentalDetailVehicleItem) ? get_class($fullRentalDetailVehicleItem) : gettype($fullRentalDetailVehicleItem)), __LINE__);
            }
        }
        $this->vehicle = $vehicle;
        return $this;
    }
    /**
     * Add item to vehicle value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToVehicle($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The vehicle property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vehicle[] = $item;
        return $this;
    }
    /**
     * Get lastBillingDate value
     * @return mixed|null
     */
    public function getLastBillingDate()
    {
        return $this->lastBillingDate;
    }
    /**
     * Set lastBillingDate value
     * @param mixed $lastBillingDate
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setLastBillingDate($lastBillingDate = null)
    {
        $this->lastBillingDate = $lastBillingDate;
        return $this;
    }
    /**
     * Get error value
     * @return mixed[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param mixed[] $error
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $fullRentalDetailErrorItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($fullRentalDetailErrorItem) ? get_class($fullRentalDetailErrorItem) : gettype($fullRentalDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function addToError($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
