<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rates StructType
 * Meta informations extracted from the WSDL
 * - type: tns:rates
 * @subpackage Structs
 */
class Rates extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The contractId
     * @var mixed
     */
    public $contractId;
    /**
     * The modelRequested
     * @var string
     */
    public $modelRequested;
    /**
     * The start
     * @var mixed
     */
    public $start;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The specialCharges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $specialCharges;
    /**
     * The grossCharge
     * @var string
     */
    public $grossCharge;
    /**
     * The totalVat
     * @var string
     */
    public $totalVat;
    /**
     * The netCharge
     * @var string
     */
    public $netCharge;
    /**
     * The noOfLines
     * @var string
     */
    public $noOfLines;
    /**
     * The errorNo
     * @var string
     */
    public $errorNo;
    /**
     * The errorMessage
     * @var string
     */
    public $errorMessage;
    /**
     * The charge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $charge;
    /**
     * Constructor method for rates
     * @uses Rates::setAuthentication()
     * @uses Rates::setContractId()
     * @uses Rates::setModelRequested()
     * @uses Rates::setStart()
     * @uses Rates::setEnd()
     * @uses Rates::setSpecialCharges()
     * @uses Rates::setGrossCharge()
     * @uses Rates::setTotalVat()
     * @uses Rates::setNetCharge()
     * @uses Rates::setNoOfLines()
     * @uses Rates::setErrorNo()
     * @uses Rates::setErrorMessage()
     * @uses Rates::setCharge()
     * @param mixed $authentication
     * @param mixed $contractId
     * @param string $modelRequested
     * @param mixed $start
     * @param mixed $end
     * @param mixed $specialCharges
     * @param string $grossCharge
     * @param string $totalVat
     * @param string $netCharge
     * @param string $noOfLines
     * @param string $errorNo
     * @param string $errorMessage
     * @param mixed $charge
     */
    public function __construct($authentication = null, $contractId = null, $modelRequested = null, $start = null, $end = null, $specialCharges = null, $grossCharge = null, $totalVat = null, $netCharge = null, $noOfLines = null, $errorNo = null, $errorMessage = null, $charge = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setStart($start)
            ->setEnd($end)
            ->setSpecialCharges($specialCharges)
            ->setGrossCharge($grossCharge)
            ->setTotalVat($totalVat)
            ->setNetCharge($netCharge)
            ->setNoOfLines($noOfLines)
            ->setErrorNo($errorNo)
            ->setErrorMessage($errorMessage)
            ->setCharge($charge);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get contractId value
     * @return mixed|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param mixed $contractId
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setContractId($contractId = null)
    {
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return string|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param string $modelRequested
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setModelRequested($modelRequested = null)
    {
        // validation for constraint: string
        if (!is_null($modelRequested) && !is_string($modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelRequested)), __LINE__);
        }
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get start value
     * @return mixed|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param mixed $start
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get specialCharges value
     * @return mixed|null
     */
    public function getSpecialCharges()
    {
        return $this->specialCharges;
    }
    /**
     * Set specialCharges value
     * @param mixed $specialCharges
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setSpecialCharges($specialCharges = null)
    {
        $this->specialCharges = $specialCharges;
        return $this;
    }
    /**
     * Get grossCharge value
     * @return string|null
     */
    public function getGrossCharge()
    {
        return $this->grossCharge;
    }
    /**
     * Set grossCharge value
     * @param string $grossCharge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setGrossCharge($grossCharge = null)
    {
        // validation for constraint: string
        if (!is_null($grossCharge) && !is_string($grossCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grossCharge)), __LINE__);
        }
        $this->grossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get totalVat value
     * @return string|null
     */
    public function getTotalVat()
    {
        return $this->totalVat;
    }
    /**
     * Set totalVat value
     * @param string $totalVat
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setTotalVat($totalVat = null)
    {
        // validation for constraint: string
        if (!is_null($totalVat) && !is_string($totalVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalVat)), __LINE__);
        }
        $this->totalVat = $totalVat;
        return $this;
    }
    /**
     * Get netCharge value
     * @return string|null
     */
    public function getNetCharge()
    {
        return $this->netCharge;
    }
    /**
     * Set netCharge value
     * @param string $netCharge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setNetCharge($netCharge = null)
    {
        // validation for constraint: string
        if (!is_null($netCharge) && !is_string($netCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($netCharge)), __LINE__);
        }
        $this->netCharge = $netCharge;
        return $this;
    }
    /**
     * Get noOfLines value
     * @return string|null
     */
    public function getNoOfLines()
    {
        return $this->noOfLines;
    }
    /**
     * Set noOfLines value
     * @param string $noOfLines
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setNoOfLines($noOfLines = null)
    {
        // validation for constraint: string
        if (!is_null($noOfLines) && !is_string($noOfLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfLines)), __LINE__);
        }
        $this->noOfLines = $noOfLines;
        return $this;
    }
    /**
     * Get errorNo value
     * @return string|null
     */
    public function getErrorNo()
    {
        return $this->errorNo;
    }
    /**
     * Set errorNo value
     * @param string $errorNo
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setErrorNo($errorNo = null)
    {
        // validation for constraint: string
        if (!is_null($errorNo) && !is_string($errorNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorNo)), __LINE__);
        }
        $this->errorNo = $errorNo;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get charge value
     * @return mixed|null
     */
    public function getCharge()
    {
        return $this->charge;
    }
    /**
     * Set charge value
     * @param mixed $charge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setCharge($charge = null)
    {
        $this->charge = $charge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Rates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
