<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offhireDetail StructType
 * @subpackage Structs
 */
class OffhireDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $note;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $error;
    /**
     * Constructor method for offhireDetail
     * @uses OffhireDetail::setAuthentication()
     * @uses OffhireDetail::setReservationNumber()
     * @uses OffhireDetail::setRentalNumber()
     * @uses OffhireDetail::setEnd()
     * @uses OffhireDetail::setNote()
     * @uses OffhireDetail::setError()
     * @param mixed $authentication
     * @param int $reservationNumber
     * @param int $rentalNumber
     * @param mixed $end
     * @param mixed[] $note
     * @param mixed[] $error
     */
    public function __construct($authentication = null, $reservationNumber = null, $rentalNumber = null, $end = null, array $note = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setRentalNumber($rentalNumber)
            ->setEnd($end)
            ->setNote($note)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get note value
     * @return mixed[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param mixed[] $note
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $offhireDetailNoteItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($offhireDetailNoteItem) ? get_class($offhireDetailNoteItem) : gettype($offhireDetailNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return mixed[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param mixed[] $error
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $offhireDetailErrorItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($offhireDetailErrorItem) ? get_class($offhireDetailErrorItem) : gettype($offhireDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function addToError($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
