<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driverDetailsType StructType
 * @subpackage Structs
 */
class DriverDetailsType extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxLength: 10
     * @var string
     */
    public $title;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 25
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxLength: 25
     * @var string
     */
    public $lastName;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $address;
    /**
     * The countryOfResidence
     * @var mixed
     */
    public $countryOfResidence;
    /**
     * The dateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $dateOfBirth;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $email;
    /**
     * The licence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $licence;
    /**
     * Constructor method for driverDetailsType
     * @uses DriverDetailsType::setTitle()
     * @uses DriverDetailsType::setFirstName()
     * @uses DriverDetailsType::setLastName()
     * @uses DriverDetailsType::setAddress()
     * @uses DriverDetailsType::setCountryOfResidence()
     * @uses DriverDetailsType::setDateOfBirth()
     * @uses DriverDetailsType::setEmail()
     * @uses DriverDetailsType::setLicence()
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     * @param mixed[] $address
     * @param mixed $countryOfResidence
     * @param mixed $dateOfBirth
     * @param mixed $email
     * @param mixed $licence
     */
    public function __construct($title = null, $firstName = null, $lastName = null, array $address = array(), $countryOfResidence = null, $dateOfBirth = null, $email = null, $licence = null)
    {
        $this
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setAddress($address)
            ->setCountryOfResidence($countryOfResidence)
            ->setDateOfBirth($dateOfBirth)
            ->setEmail($email)
            ->setLicence($licence);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($title) && strlen($title) > 10) || (is_array($title) && count($title) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($title) ? strlen($title) : count($title)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firstName) && strlen($firstName) > 25) || (is_array($firstName) && count($firstName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($firstName) ? strlen($firstName) : count($firstName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lastName) && strlen($lastName) > 25) || (is_array($lastName) && count($lastName) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($lastName) ? strlen($lastName) : count($lastName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get address value
     * @return mixed[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param mixed[] $address
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setAddress(array $address = array())
    {
        foreach ($address as $driverDetailsTypeAddressItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The address property can only contain items of anyType, "%s" given', is_object($driverDetailsTypeAddressItem) ? get_class($driverDetailsTypeAddressItem) : gettype($driverDetailsTypeAddressItem)), __LINE__);
            }
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function addToAddress($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get countryOfResidence value
     * @return mixed|null
     */
    public function getCountryOfResidence()
    {
        return $this->countryOfResidence;
    }
    /**
     * Set countryOfResidence value
     * @param mixed $countryOfResidence
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        $this->countryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get dateOfBirth value
     * @return mixed|null
     */
    public function getDateOfBirth()
    {
        return $this->dateOfBirth;
    }
    /**
     * Set dateOfBirth value
     * @param mixed $dateOfBirth
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        $this->dateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get email value
     * @return mixed|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param mixed $email
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get licence value
     * @return mixed|null
     */
    public function getLicence()
    {
        return $this->licence;
    }
    /**
     * Set licence value
     * @param mixed $licence
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public function setLicence($licence = null)
    {
        $this->licence = $licence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\DriverDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
