<?php

namespace GreenwayDirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checkout ServiceType
 * @subpackage Services
 */
class Checkout extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkoutRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkoutRA $checkoutRA
     * @return checkoutRA|bool
     */
    public function checkoutRA($checkoutRA)
    {
        try {
            $this->setResult(self::getSoapClient()->checkoutRA($checkoutRA));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return checkoutRA
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
