<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offhireDetail StructType
 * @subpackage Structs
 */
class OffhireDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The note
     * @var mixed
     */
    public $note;
    /**
     * The error
     * @var mixed
     */
    public $error;
    /**
     * Constructor method for offhireDetail
     * @uses OffhireDetail::setAuthentication()
     * @uses OffhireDetail::setReservationNumber()
     * @uses OffhireDetail::setRentalNumber()
     * @uses OffhireDetail::setEnd()
     * @uses OffhireDetail::setNote()
     * @uses OffhireDetail::setError()
     * @param mixed $authentication
     * @param int $reservationNumber
     * @param int $rentalNumber
     * @param mixed $end
     * @param mixed $note
     * @param mixed $error
     */
    public function __construct($authentication = null, $reservationNumber = null, $rentalNumber = null, $end = null, $note = null, $error = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setRentalNumber($rentalNumber)
            ->setEnd($end)
            ->setNote($note)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get note value
     * @return mixed|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param mixed $note
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setNote($note = null)
    {
        $this->note = $note;
        return $this;
    }
    /**
     * Get error value
     * @return mixed|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param mixed $error
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public function setError($error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\OffhireDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
