<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for phoneNumberType StructType
 * @subpackage Structs
 */
class PhoneNumberType extends AbstractStructBase
{
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - type: tns:phoneType
     * @var phoneNumber
     */
    public $phoneNumber;
    /**
     * The phoneType
     * @var string
     */
    public $phoneType;
    /**
     * Constructor method for phoneNumberType
     * @uses PhoneNumberType::setPhoneNumber()
     * @uses PhoneNumberType::setPhoneType()
     * @param phoneNumber $phoneNumber
     * @param string $phoneType
     */
    public function __construct(phoneNumber $phoneNumber = null, $phoneType = null)
    {
        $this
            ->setPhoneNumber($phoneNumber)
            ->setPhoneType($phoneType);
    }
    /**
     * Get phoneNumber value
     * @return phoneNumber|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param phoneNumber $phoneNumber
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public function setPhoneNumber(phoneNumber $phoneNumber = null)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses \GreenwayDirectService\EnumType\PhoneType::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\PhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\PhoneType::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', \GreenwayDirectService\EnumType\PhoneType::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\PhoneNumberType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
