<?php

namespace GreenwayDirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Amend ServiceType
 * @subpackage Services
 */
class Amend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named amendOffhire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param amendOffhire $amendOffhire
     * @return amendOffhireResponse|bool
     */
    public function amendOffhire($amendOffhire)
    {
        try {
            $this->setResult(self::getSoapClient()->amendOffhire($amendOffhire));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param amendReservation $amendReservation
     * @return amendReservationResponse|bool
     */
    public function amendReservation($amendReservation)
    {
        try {
            $this->setResult(self::getSoapClient()->amendReservation($amendReservation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendRA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param amendRA $amendRA
     * @return amendRA|bool
     */
    public function amendRA($amendRA)
    {
        try {
            $this->setResult(self::getSoapClient()->amendRA($amendRA));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return amendOffhireResponse|amendRA|amendReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
