<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vehicleDetail StructType
 * @subpackage Structs
 */
class VehicleDetail extends AbstractStructBase
{
    /**
     * The registrationNumber
     * @var registrationNumber
     */
    public $registrationNumber;
    /**
     * The suppliedModel
     * @var mixed
     */
    public $suppliedModel;
    /**
     * The outDate
     * @var mixed
     */
    public $outDate;
    /**
     * The outTime
     * @var mixed
     */
    public $outTime;
    /**
     * The outOdometer
     * @var int
     */
    public $outOdometer;
    /**
     * The inOdometer
     * @var int
     */
    public $inOdometer;
    /**
     * The inDate
     * @var mixed
     */
    public $inDate;
    /**
     * The inTime
     * @var mixed
     */
    public $inTime;
    /**
     * The modelDescription
     * @var string
     */
    public $modelDescription;
    /**
     * The registrationDate
     * @var mixed
     */
    public $registrationDate;
    /**
     * The transmission
     * @var mixed
     */
    public $transmission;
    /**
     * The CO2
     * @var float
     */
    public $CO2;
    /**
     * The engineSize
     * @var int
     */
    public $engineSize;
    /**
     * The P11DValue
     * @var float
     */
    public $P11DValue;
    /**
     * The fuelType
     * @var mixed
     */
    public $fuelType;
    /**
     * Constructor method for vehicleDetail
     * @uses VehicleDetail::setRegistrationNumber()
     * @uses VehicleDetail::setSuppliedModel()
     * @uses VehicleDetail::setOutDate()
     * @uses VehicleDetail::setOutTime()
     * @uses VehicleDetail::setOutOdometer()
     * @uses VehicleDetail::setInOdometer()
     * @uses VehicleDetail::setInDate()
     * @uses VehicleDetail::setInTime()
     * @uses VehicleDetail::setModelDescription()
     * @uses VehicleDetail::setRegistrationDate()
     * @uses VehicleDetail::setTransmission()
     * @uses VehicleDetail::setCO2()
     * @uses VehicleDetail::setEngineSize()
     * @uses VehicleDetail::setP11DValue()
     * @uses VehicleDetail::setFuelType()
     * @param registrationNumber $registrationNumber
     * @param mixed $suppliedModel
     * @param mixed $outDate
     * @param mixed $outTime
     * @param int $outOdometer
     * @param int $inOdometer
     * @param mixed $inDate
     * @param mixed $inTime
     * @param string $modelDescription
     * @param mixed $registrationDate
     * @param mixed $transmission
     * @param float $cO2
     * @param int $engineSize
     * @param float $p11DValue
     * @param mixed $fuelType
     */
    public function __construct(registrationNumber $registrationNumber = null, $suppliedModel = null, $outDate = null, $outTime = null, $outOdometer = null, $inOdometer = null, $inDate = null, $inTime = null, $modelDescription = null, $registrationDate = null, $transmission = null, $cO2 = null, $engineSize = null, $p11DValue = null, $fuelType = null)
    {
        $this
            ->setRegistrationNumber($registrationNumber)
            ->setSuppliedModel($suppliedModel)
            ->setOutDate($outDate)
            ->setOutTime($outTime)
            ->setOutOdometer($outOdometer)
            ->setInOdometer($inOdometer)
            ->setInDate($inDate)
            ->setInTime($inTime)
            ->setModelDescription($modelDescription)
            ->setRegistrationDate($registrationDate)
            ->setTransmission($transmission)
            ->setCO2($cO2)
            ->setEngineSize($engineSize)
            ->setP11DValue($p11DValue)
            ->setFuelType($fuelType);
    }
    /**
     * Get registrationNumber value
     * @return registrationNumber|null
     */
    public function getRegistrationNumber()
    {
        return $this->registrationNumber;
    }
    /**
     * Set registrationNumber value
     * @param registrationNumber $registrationNumber
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setRegistrationNumber(registrationNumber $registrationNumber = null)
    {
        $this->registrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get suppliedModel value
     * @return mixed|null
     */
    public function getSuppliedModel()
    {
        return $this->suppliedModel;
    }
    /**
     * Set suppliedModel value
     * @param mixed $suppliedModel
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setSuppliedModel($suppliedModel = null)
    {
        $this->suppliedModel = $suppliedModel;
        return $this;
    }
    /**
     * Get outDate value
     * @return mixed|null
     */
    public function getOutDate()
    {
        return $this->outDate;
    }
    /**
     * Set outDate value
     * @param mixed $outDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutDate($outDate = null)
    {
        $this->outDate = $outDate;
        return $this;
    }
    /**
     * Get outTime value
     * @return mixed|null
     */
    public function getOutTime()
    {
        return $this->outTime;
    }
    /**
     * Set outTime value
     * @param mixed $outTime
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutTime($outTime = null)
    {
        $this->outTime = $outTime;
        return $this;
    }
    /**
     * Get outOdometer value
     * @return int|null
     */
    public function getOutOdometer()
    {
        return $this->outOdometer;
    }
    /**
     * Set outOdometer value
     * @param int $outOdometer
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setOutOdometer($outOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($outOdometer) && !is_numeric($outOdometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outOdometer)), __LINE__);
        }
        $this->outOdometer = $outOdometer;
        return $this;
    }
    /**
     * Get inOdometer value
     * @return int|null
     */
    public function getInOdometer()
    {
        return $this->inOdometer;
    }
    /**
     * Set inOdometer value
     * @param int $inOdometer
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInOdometer($inOdometer = null)
    {
        // validation for constraint: int
        if (!is_null($inOdometer) && !is_numeric($inOdometer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($inOdometer)), __LINE__);
        }
        $this->inOdometer = $inOdometer;
        return $this;
    }
    /**
     * Get inDate value
     * @return mixed|null
     */
    public function getInDate()
    {
        return $this->inDate;
    }
    /**
     * Set inDate value
     * @param mixed $inDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInDate($inDate = null)
    {
        $this->inDate = $inDate;
        return $this;
    }
    /**
     * Get inTime value
     * @return mixed|null
     */
    public function getInTime()
    {
        return $this->inTime;
    }
    /**
     * Set inTime value
     * @param mixed $inTime
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setInTime($inTime = null)
    {
        $this->inTime = $inTime;
        return $this;
    }
    /**
     * Get modelDescription value
     * @return string|null
     */
    public function getModelDescription()
    {
        return $this->modelDescription;
    }
    /**
     * Set modelDescription value
     * @param string $modelDescription
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setModelDescription($modelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($modelDescription) && !is_string($modelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelDescription)), __LINE__);
        }
        $this->modelDescription = $modelDescription;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return mixed|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param mixed $registrationDate
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setRegistrationDate($registrationDate = null)
    {
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get transmission value
     * @return mixed|null
     */
    public function getTransmission()
    {
        return $this->transmission;
    }
    /**
     * Set transmission value
     * @param mixed $transmission
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setTransmission($transmission = null)
    {
        $this->transmission = $transmission;
        return $this;
    }
    /**
     * Get CO2 value
     * @return float|null
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param float $cO2
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setCO2($cO2 = null)
    {
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get engineSize value
     * @return int|null
     */
    public function getEngineSize()
    {
        return $this->engineSize;
    }
    /**
     * Set engineSize value
     * @param int $engineSize
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setEngineSize($engineSize = null)
    {
        // validation for constraint: int
        if (!is_null($engineSize) && !is_numeric($engineSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($engineSize)), __LINE__);
        }
        $this->engineSize = $engineSize;
        return $this;
    }
    /**
     * Get P11DValue value
     * @return float|null
     */
    public function getP11DValue()
    {
        return $this->P11DValue;
    }
    /**
     * Set P11DValue value
     * @param float $p11DValue
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setP11DValue($p11DValue = null)
    {
        $this->P11DValue = $p11DValue;
        return $this;
    }
    /**
     * Get fuelType value
     * @return mixed|null
     */
    public function getFuelType()
    {
        return $this->fuelType;
    }
    /**
     * Set fuelType value
     * @param mixed $fuelType
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public function setFuelType($fuelType = null)
    {
        $this->fuelType = $fuelType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\VehicleDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
