<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fullRentalDetail StructType
 * @subpackage Structs
 */
class FullRentalDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The rentalNumber
     * @var int
     */
    public $rentalNumber;
    /**
     * The rentalUpdateType
     * @var mixed
     */
    public $rentalUpdateType;
    /**
     * The reservationNumber
     * @var int
     */
    public $reservationNumber;
    /**
     * The contractId
     * @var mixed
     */
    public $contractId;
    /**
     * The modelRequested
     * @var mixed
     */
    public $modelRequested;
    /**
     * The iataNumber
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var mixed
     */
    public $start;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The driver
     * @var mixed
     */
    public $driver;
    /**
     * The payment
     * @var mixed
     */
    public $payment;
    /**
     * The customerReference
     * @var mixed
     */
    public $customerReference;
    /**
     * The note
     * @var mixed
     */
    public $note;
    /**
     * The charges
     * @var mixed
     */
    public $charges;
    /**
     * The vehicle
     * @var mixed
     */
    public $vehicle;
    /**
     * The lastBillingDate
     * @var mixed
     */
    public $lastBillingDate;
    /**
     * The error
     * @var mixed
     */
    public $error;
    /**
     * Constructor method for fullRentalDetail
     * @uses FullRentalDetail::setAuthentication()
     * @uses FullRentalDetail::setRentalNumber()
     * @uses FullRentalDetail::setRentalUpdateType()
     * @uses FullRentalDetail::setReservationNumber()
     * @uses FullRentalDetail::setContractId()
     * @uses FullRentalDetail::setModelRequested()
     * @uses FullRentalDetail::setIataNumber()
     * @uses FullRentalDetail::setFlightNumber()
     * @uses FullRentalDetail::setStart()
     * @uses FullRentalDetail::setEnd()
     * @uses FullRentalDetail::setDriver()
     * @uses FullRentalDetail::setPayment()
     * @uses FullRentalDetail::setCustomerReference()
     * @uses FullRentalDetail::setNote()
     * @uses FullRentalDetail::setCharges()
     * @uses FullRentalDetail::setVehicle()
     * @uses FullRentalDetail::setLastBillingDate()
     * @uses FullRentalDetail::setError()
     * @param mixed $authentication
     * @param int $rentalNumber
     * @param mixed $rentalUpdateType
     * @param int $reservationNumber
     * @param mixed $contractId
     * @param mixed $modelRequested
     * @param string $iataNumber
     * @param string $flightNumber
     * @param mixed $start
     * @param mixed $end
     * @param mixed $driver
     * @param mixed $payment
     * @param mixed $customerReference
     * @param mixed $note
     * @param mixed $charges
     * @param mixed $vehicle
     * @param mixed $lastBillingDate
     * @param mixed $error
     */
    public function __construct($authentication = null, $rentalNumber = null, $rentalUpdateType = null, $reservationNumber = null, $contractId = null, $modelRequested = null, $iataNumber = null, $flightNumber = null, $start = null, $end = null, $driver = null, $payment = null, $customerReference = null, $note = null, $charges = null, $vehicle = null, $lastBillingDate = null, $error = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setRentalNumber($rentalNumber)
            ->setRentalUpdateType($rentalUpdateType)
            ->setReservationNumber($reservationNumber)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setCharges($charges)
            ->setVehicle($vehicle)
            ->setLastBillingDate($lastBillingDate)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return int|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param int $rentalNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rentalNumber) && !is_numeric($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get rentalUpdateType value
     * @return mixed|null
     */
    public function getRentalUpdateType()
    {
        return $this->rentalUpdateType;
    }
    /**
     * Set rentalUpdateType value
     * @param mixed $rentalUpdateType
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setRentalUpdateType($rentalUpdateType = null)
    {
        $this->rentalUpdateType = $rentalUpdateType;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get contractId value
     * @return mixed|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param mixed $contractId
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setContractId($contractId = null)
    {
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return mixed|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param mixed $modelRequested
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setModelRequested($modelRequested = null)
    {
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return mixed|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param mixed $start
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return mixed|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @param mixed $driver
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setDriver($driver = null)
    {
        $this->driver = $driver;
        return $this;
    }
    /**
     * Get payment value
     * @return mixed|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param mixed $payment
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setPayment($payment = null)
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get customerReference value
     * @return mixed|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @param mixed $customerReference
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setCustomerReference($customerReference = null)
    {
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Get note value
     * @return mixed|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param mixed $note
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setNote($note = null)
    {
        $this->note = $note;
        return $this;
    }
    /**
     * Get charges value
     * @return mixed|null
     */
    public function getCharges()
    {
        return $this->charges;
    }
    /**
     * Set charges value
     * @param mixed $charges
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setCharges($charges = null)
    {
        $this->charges = $charges;
        return $this;
    }
    /**
     * Get vehicle value
     * @return mixed|null
     */
    public function getVehicle()
    {
        return $this->vehicle;
    }
    /**
     * Set vehicle value
     * @param mixed $vehicle
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setVehicle($vehicle = null)
    {
        $this->vehicle = $vehicle;
        return $this;
    }
    /**
     * Get lastBillingDate value
     * @return mixed|null
     */
    public function getLastBillingDate()
    {
        return $this->lastBillingDate;
    }
    /**
     * Set lastBillingDate value
     * @param mixed $lastBillingDate
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setLastBillingDate($lastBillingDate = null)
    {
        $this->lastBillingDate = $lastBillingDate;
        return $this;
    }
    /**
     * Get error value
     * @return mixed|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param mixed $error
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public function setError($error = null)
    {
        $this->error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\FullRentalDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
