<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alpha.fleetcontrolsystem.com/api/FCSGreenway.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alpha.fleetcontrolsystem.com/api/FCSGreenway.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GreenwayDirectService\ClassMap::get(),
);
/**
 * Samples for Amend ServiceType
 */
$amend = new \GreenwayDirectService\ServiceType\Amend($options);
/**
 * Sample call for amendOffhire operation/method
 */
if ($amend->amendOffhire($amendOffhire) !== false) {
    print_r($amend->getResult());
} else {
    print_r($amend->getLastError());
}
/**
 * Sample call for amendReservation operation/method
 */
if ($amend->amendReservation($amendReservation) !== false) {
    print_r($amend->getResult());
} else {
    print_r($amend->getLastError());
}
/**
 * Sample call for amendRA operation/method
 */
if ($amend->amendRA($amendRA) !== false) {
    print_r($amend->getResult());
} else {
    print_r($amend->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \GreenwayDirectService\ServiceType\Cancel($options);
/**
 * Sample call for cancelReservation operation/method
 */
if ($cancel->cancelReservation($cancelReservationInfo) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for cancelRA operation/method
 */
if ($cancel->cancelRA($cancelRA) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for New ServiceType
 */
$new = new \GreenwayDirectService\ServiceType\_New($options);
/**
 * Sample call for newReservation operation/method
 */
if ($new->newReservation(new \GreenwayDirectService\StructType\NewReservation()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \GreenwayDirectService\ServiceType\Get($options);
/**
 * Sample call for getQuote operation/method
 */
if ($get->getQuote($getQuote) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Checkout ServiceType
 */
$checkout = new \GreenwayDirectService\ServiceType\Checkout($options);
/**
 * Sample call for checkoutRA operation/method
 */
if ($checkout->checkoutRA($checkoutRA) !== false) {
    print_r($checkout->getResult());
} else {
    print_r($checkout->getLastError());
}
/**
 * Samples for Checkin ServiceType
 */
$checkin = new \GreenwayDirectService\ServiceType\Checkin($options);
/**
 * Sample call for checkinRA operation/method
 */
if ($checkin->checkinRA($checkinRA) !== false) {
    print_r($checkin->getResult());
} else {
    print_r($checkin->getLastError());
}
