<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fullResDetail StructType
 * @subpackage Structs
 */
class FullResDetail extends AbstractStructBase
{
    /**
     * The authentication
     * @var mixed
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reservationNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $status;
    /**
     * The contractId
     * @var mixed
     */
    public $contractId;
    /**
     * The modelRequested
     * @var mixed
     */
    public $modelRequested;
    /**
     * The contactTelNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var contactTelNo
     */
    public $contactTelNo;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var contactName
     */
    public $contactName;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The start
     * @var mixed
     */
    public $start;
    /**
     * The end
     * @var mixed
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var mixed[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var mixed[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var mixed[]
     */
    public $note;
    /**
     * The equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var mixed[]
     */
    public $equipment;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var mixed[]
     */
    public $charges;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $error;
    /**
     * Constructor method for fullResDetail
     * @uses FullResDetail::setAuthentication()
     * @uses FullResDetail::setReservationNumber()
     * @uses FullResDetail::setStatus()
     * @uses FullResDetail::setContractId()
     * @uses FullResDetail::setModelRequested()
     * @uses FullResDetail::setContactTelNo()
     * @uses FullResDetail::setContactName()
     * @uses FullResDetail::setIataNumber()
     * @uses FullResDetail::setFlightNumber()
     * @uses FullResDetail::setStart()
     * @uses FullResDetail::setEnd()
     * @uses FullResDetail::setDriver()
     * @uses FullResDetail::setPayment()
     * @uses FullResDetail::setCustomerReference()
     * @uses FullResDetail::setNote()
     * @uses FullResDetail::setEquipment()
     * @uses FullResDetail::setCharges()
     * @uses FullResDetail::setError()
     * @param mixed $authentication
     * @param int $reservationNumber
     * @param mixed $status
     * @param mixed $contractId
     * @param mixed $modelRequested
     * @param contactTelNo $contactTelNo
     * @param contactName $contactName
     * @param string $iataNumber
     * @param string $flightNumber
     * @param mixed $start
     * @param mixed $end
     * @param mixed[] $driver
     * @param mixed[] $payment
     * @param mixed[] $customerReference
     * @param mixed[] $note
     * @param mixed[] $equipment
     * @param mixed[] $charges
     * @param mixed[] $error
     */
    public function __construct($authentication = null, $reservationNumber = null, $status = null, $contractId = null, $modelRequested = null, contactTelNo $contactTelNo = null, contactName $contactName = null, $iataNumber = null, $flightNumber = null, $start = null, $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $equipment = array(), array $charges = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setStatus($status)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setContactTelNo($contactTelNo)
            ->setContactName($contactName)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setEquipment($equipment)
            ->setCharges($charges)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return mixed|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param mixed $authentication
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setAuthentication($authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return int|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param int $reservationNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: int
        if (!is_null($reservationNumber) && !is_numeric($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get status value
     * @return mixed|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param mixed $status
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get contractId value
     * @return mixed|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param mixed $contractId
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContractId($contractId = null)
    {
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return mixed|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param mixed $modelRequested
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setModelRequested($modelRequested = null)
    {
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get contactTelNo value
     * @return contactTelNo|null
     */
    public function getContactTelNo()
    {
        return $this->contactTelNo;
    }
    /**
     * Set contactTelNo value
     * @param contactTelNo $contactTelNo
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContactTelNo(contactTelNo $contactTelNo = null)
    {
        $this->contactTelNo = $contactTelNo;
        return $this;
    }
    /**
     * Get contactName value
     * @return contactName|null
     */
    public function getContactName()
    {
        return $this->contactName;
    }
    /**
     * Set contactName value
     * @param contactName $contactName
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setContactName(contactName $contactName = null)
    {
        $this->contactName = $contactName;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get start value
     * @return mixed|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param mixed $start
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return mixed|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param mixed $end
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return mixed[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param mixed[] $driver
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $fullResDetailDriverItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of anyType, "%s" given', is_object($fullResDetailDriverItem) ? get_class($fullResDetailDriverItem) : gettype($fullResDetailDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToDriver($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed[]|null
     */
    public function getPayment()
    {
        return isset($this->payment) ? $this->payment : null;
    }
    /**
     * Set payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed[] $payment
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $fullResDetailPaymentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of anyType, "%s" given', is_object($fullResDetailPaymentItem) ? get_class($fullResDetailPaymentItem) : gettype($fullResDetailPaymentItem)), __LINE__);
            }
        }
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->payment);
        } else {
            $this->payment = $payment;
        }
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToPayment($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed[]|null
     */
    public function getCustomerReference()
    {
        return isset($this->customerReference) ? $this->customerReference : null;
    }
    /**
     * Set customerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed[] $customerReference
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $fullResDetailCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of anyType, "%s" given', is_object($fullResDetailCustomerReferenceItem) ? get_class($fullResDetailCustomerReferenceItem) : gettype($fullResDetailCustomerReferenceItem)), __LINE__);
            }
        }
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->customerReference);
        } else {
            $this->customerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToCustomerReference($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed[]|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed[] $note
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $fullResDetailNoteItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($fullResDetailNoteItem) ? get_class($fullResDetailNoteItem) : gettype($fullResDetailNoteItem)), __LINE__);
            }
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToNote($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get equipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed[]|null
     */
    public function getEquipment()
    {
        return isset($this->equipment) ? $this->equipment : null;
    }
    /**
     * Set equipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed[] $equipment
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $fullResDetailEquipmentItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of anyType, "%s" given', is_object($fullResDetailEquipmentItem) ? get_class($fullResDetailEquipmentItem) : gettype($fullResDetailEquipmentItem)), __LINE__);
            }
        }
        if (is_null($equipment) || (is_array($equipment) && empty($equipment))) {
            unset($this->equipment);
        } else {
            $this->equipment = $equipment;
        }
        return $this;
    }
    /**
     * Add item to equipment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToEquipment($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->equipment[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed[]|null
     */
    public function getCharges()
    {
        return isset($this->charges) ? $this->charges : null;
    }
    /**
     * Set charges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed[] $charges
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $fullResDetailChargesItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of anyType, "%s" given', is_object($fullResDetailChargesItem) ? get_class($fullResDetailChargesItem) : gettype($fullResDetailChargesItem)), __LINE__);
            }
        }
        if (is_null($charges) || (is_array($charges) && empty($charges))) {
            unset($this->charges);
        } else {
            $this->charges = $charges;
        }
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToCharges($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return mixed[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param mixed[] $error
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function setError(array $error = array())
    {
        foreach ($error as $fullResDetailErrorItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($fullResDetailErrorItem) ? get_class($fullResDetailErrorItem) : gettype($fullResDetailErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public function addToError($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\FullResDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
