<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driverType StructType
 * @subpackage Structs
 */
class DriverType extends AbstractStructBase
{
    /**
     * The primaryDriver
     * @var mixed
     */
    public $primaryDriver;
    /**
     * The driverId
     * @var int
     */
    public $driverId;
    /**
     * The driverDetails
     * @var mixed
     */
    public $driverDetails;
    /**
     * Constructor method for driverType
     * @uses DriverType::setPrimaryDriver()
     * @uses DriverType::setDriverId()
     * @uses DriverType::setDriverDetails()
     * @param mixed $primaryDriver
     * @param int $driverId
     * @param mixed $driverDetails
     */
    public function __construct($primaryDriver = null, $driverId = null, $driverDetails = null)
    {
        $this
            ->setPrimaryDriver($primaryDriver)
            ->setDriverId($driverId)
            ->setDriverDetails($driverDetails);
    }
    /**
     * Get primaryDriver value
     * @return mixed|null
     */
    public function getPrimaryDriver()
    {
        return $this->primaryDriver;
    }
    /**
     * Set primaryDriver value
     * @param mixed $primaryDriver
     * @return \GreenwayDirectService\StructType\DriverType
     */
    public function setPrimaryDriver($primaryDriver = null)
    {
        $this->primaryDriver = $primaryDriver;
        return $this;
    }
    /**
     * Get driverId value
     * @return int|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param int $driverId
     * @return \GreenwayDirectService\StructType\DriverType
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: int
        if (!is_null($driverId) && !is_numeric($driverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($driverId)), __LINE__);
        }
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get driverDetails value
     * @return mixed|null
     */
    public function getDriverDetails()
    {
        return $this->driverDetails;
    }
    /**
     * Set driverDetails value
     * @param mixed $driverDetails
     * @return \GreenwayDirectService\StructType\DriverType
     */
    public function setDriverDetails($driverDetails = null)
    {
        $this->driverDetails = $driverDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\DriverType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
