<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clsTPPG StructType
 * @subpackage Structs
 */
class ClsTPPG extends AbstractStructBase
{
    /**
     * The ncapita
     * @var float
     */
    public $ncapita;
    /**
     * The nintpac
     * @var float
     */
    public $nintpac;
    /**
     * The cNroCuo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cNroCuo;
    /**
     * Constructor method for clsTPPG
     * @uses ClsTPPG::setNcapita()
     * @uses ClsTPPG::setNintpac()
     * @uses ClsTPPG::setCNroCuo()
     * @param float $ncapita
     * @param float $nintpac
     * @param string $cNroCuo
     */
    public function __construct($ncapita = null, $nintpac = null, $cNroCuo = null)
    {
        $this
            ->setNcapita($ncapita)
            ->setNintpac($nintpac)
            ->setCNroCuo($cNroCuo);
    }
    /**
     * Get ncapita value
     * @return float|null
     */
    public function getNcapita()
    {
        return $this->ncapita;
    }
    /**
     * Set ncapita value
     * @param float $ncapita
     * @return \StructType\ClsTPPG
     */
    public function setNcapita($ncapita = null)
    {
        $this->ncapita = $ncapita;
        return $this;
    }
    /**
     * Get nintpac value
     * @return float|null
     */
    public function getNintpac()
    {
        return $this->nintpac;
    }
    /**
     * Set nintpac value
     * @param float $nintpac
     * @return \StructType\ClsTPPG
     */
    public function setNintpac($nintpac = null)
    {
        $this->nintpac = $nintpac;
        return $this;
    }
    /**
     * Get cNroCuo value
     * @return string|null
     */
    public function getCNroCuo()
    {
        return $this->cNroCuo;
    }
    /**
     * Set cNroCuo value
     * @param string $cNroCuo
     * @return \StructType\ClsTPPG
     */
    public function setCNroCuo($cNroCuo = null)
    {
        // validation for constraint: string
        if (!is_null($cNroCuo) && !is_string($cNroCuo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cNroCuo)), __LINE__);
        }
        $this->cNroCuo = $cNroCuo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClsTPPG
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
