<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchResults StructType
 * @subpackage Structs
 */
class SearchResults extends AbstractStructBase
{
    /**
     * The numhits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $numhits;
    /**
     * The totalhits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $totalhits;
    /**
     * The page
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $page;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ResultType[]
     */
    public $result;
    /**
     * The warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ResultWarning[]
     */
    public $warning;
    /**
     * Constructor method for searchResults
     * @uses SearchResults::setNumhits()
     * @uses SearchResults::setTotalhits()
     * @uses SearchResults::setPage()
     * @uses SearchResults::setLanguage()
     * @uses SearchResults::setResult()
     * @uses SearchResults::setWarning()
     * @param int $numhits
     * @param int $totalhits
     * @param int $page
     * @param string $language
     * @param \StructType\ResultType[] $result
     * @param \StructType\ResultWarning[] $warning
     */
    public function __construct($numhits = null, $totalhits = null, $page = null, $language = null, array $result = array(), array $warning = array())
    {
        $this
            ->setNumhits($numhits)
            ->setTotalhits($totalhits)
            ->setPage($page)
            ->setLanguage($language)
            ->setResult($result)
            ->setWarning($warning);
    }
    /**
     * Get numhits value
     * @return int|null
     */
    public function getNumhits()
    {
        return $this->numhits;
    }
    /**
     * Set numhits value
     * @param int $numhits
     * @return \StructType\SearchResults
     */
    public function setNumhits($numhits = null)
    {
        // validation for constraint: int
        if (!is_null($numhits) && !is_numeric($numhits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numhits)), __LINE__);
        }
        $this->numhits = $numhits;
        return $this;
    }
    /**
     * Get totalhits value
     * @return int|null
     */
    public function getTotalhits()
    {
        return $this->totalhits;
    }
    /**
     * Set totalhits value
     * @param int $totalhits
     * @return \StructType\SearchResults
     */
    public function setTotalhits($totalhits = null)
    {
        // validation for constraint: int
        if (!is_null($totalhits) && !is_numeric($totalhits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalhits)), __LINE__);
        }
        $this->totalhits = $totalhits;
        return $this;
    }
    /**
     * Get page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param int $page
     * @return \StructType\SearchResults
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\SearchLanguageType::valueIsValid()
     * @uses \EnumType\SearchLanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\SearchResults
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchLanguageType::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \EnumType\SearchLanguageType::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\ResultType[]|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @throws \InvalidArgumentException
     * @param \StructType\ResultType[] $result
     * @return \StructType\SearchResults
     */
    public function setResult(array $result = array())
    {
        foreach ($result as $searchResultsResultItem) {
            // validation for constraint: itemType
            if (!$searchResultsResultItem instanceof \StructType\ResultType) {
                throw new \InvalidArgumentException(sprintf('The result property can only contain items of \StructType\ResultType, "%s" given', is_object($searchResultsResultItem) ? get_class($searchResultsResultItem) : gettype($searchResultsResultItem)), __LINE__);
            }
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param \StructType\ResultType $item
     * @return \StructType\SearchResults
     */
    public function addToResult(\StructType\ResultType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResultType) {
            throw new \InvalidArgumentException(sprintf('The result property can only contain items of \StructType\ResultType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->result[] = $item;
        return $this;
    }
    /**
     * Get warning value
     * @return \StructType\ResultWarning[]|null
     */
    public function getWarning()
    {
        return $this->warning;
    }
    /**
     * Set warning value
     * @throws \InvalidArgumentException
     * @param \StructType\ResultWarning[] $warning
     * @return \StructType\SearchResults
     */
    public function setWarning(array $warning = array())
    {
        foreach ($warning as $searchResultsWarningItem) {
            // validation for constraint: itemType
            if (!$searchResultsWarningItem instanceof \StructType\ResultWarning) {
                throw new \InvalidArgumentException(sprintf('The warning property can only contain items of \StructType\ResultWarning, "%s" given', is_object($searchResultsWarningItem) ? get_class($searchResultsWarningItem) : gettype($searchResultsWarningItem)), __LINE__);
            }
        }
        $this->warning = $warning;
        return $this;
    }
    /**
     * Add item to warning value
     * @throws \InvalidArgumentException
     * @param \StructType\ResultWarning $item
     * @return \StructType\SearchResults
     */
    public function addToWarning(\StructType\ResultWarning $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResultWarning) {
            throw new \InvalidArgumentException(sprintf('The warning property can only contain items of \StructType\ResultWarning, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->warning[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
