<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultType StructType
 * @subpackage Structs
 */
class ResultType extends AbstractStructBase
{
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The rank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $rank;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DocumentType
     */
    public $content;
    /**
     * The document_link
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_link[]
     */
    public $document_link;
    /**
     * Constructor method for resultType
     * @uses ResultType::setReference()
     * @uses ResultType::setRank()
     * @uses ResultType::setContent()
     * @uses ResultType::setDocument_link()
     * @param string $reference
     * @param int $rank
     * @param \StructType\DocumentType $content
     * @param \StructType\Document_link[] $document_link
     */
    public function __construct($reference = null, $rank = null, \StructType\DocumentType $content = null, array $document_link = array())
    {
        $this
            ->setReference($reference)
            ->setRank($rank)
            ->setContent($content)
            ->setDocument_link($document_link);
    }
    /**
     * Get reference value
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ResultType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get rank value
     * @return int
     */
    public function getRank()
    {
        return $this->rank;
    }
    /**
     * Set rank value
     * @param int $rank
     * @return \StructType\ResultType
     */
    public function setRank($rank = null)
    {
        // validation for constraint: int
        if (!is_null($rank) && !is_numeric($rank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rank)), __LINE__);
        }
        $this->rank = $rank;
        return $this;
    }
    /**
     * Get content value
     * @return \StructType\DocumentType
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param \StructType\DocumentType $content
     * @return \StructType\ResultType
     */
    public function setContent(\StructType\DocumentType $content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get document_link value
     * @return \StructType\Document_link[]|null
     */
    public function getDocument_link()
    {
        return $this->document_link;
    }
    /**
     * Set document_link value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_link[] $document_link
     * @return \StructType\ResultType
     */
    public function setDocument_link(array $document_link = array())
    {
        foreach ($document_link as $resultTypeDocument_linkItem) {
            // validation for constraint: itemType
            if (!$resultTypeDocument_linkItem instanceof \StructType\Document_link) {
                throw new \InvalidArgumentException(sprintf('The document_link property can only contain items of \StructType\Document_link, "%s" given', is_object($resultTypeDocument_linkItem) ? get_class($resultTypeDocument_linkItem) : gettype($resultTypeDocument_linkItem)), __LINE__);
            }
        }
        $this->document_link = $document_link;
        return $this;
    }
    /**
     * Add item to document_link value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_link $item
     * @return \StructType\ResultType
     */
    public function addToDocument_link(\StructType\Document_link $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_link) {
            throw new \InvalidArgumentException(sprintf('The document_link property can only contain items of \StructType\Document_link, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->document_link[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
