<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fallbackLabel StructType
 * @subpackage Structs
 */
class FallbackLabel extends AbstractStructBase
{
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The preferredLabel
     * @var string
     */
    public $preferredLabel;
    /**
     * Constructor method for fallbackLabel
     * @uses FallbackLabel::setLanguage()
     * @uses FallbackLabel::setPreferredLabel()
     * @param string $language
     * @param string $preferredLabel
     */
    public function __construct($language = null, $preferredLabel = null)
    {
        $this
            ->setLanguage($language)
            ->setPreferredLabel($preferredLabel);
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\FallbackLabel
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get preferredLabel value
     * @return string|null
     */
    public function getPreferredLabel()
    {
        return $this->preferredLabel;
    }
    /**
     * Set preferredLabel value
     * @param string $preferredLabel
     * @return \StructType\FallbackLabel
     */
    public function setPreferredLabel($preferredLabel = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLabel) && !is_string($preferredLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLabel)), __LINE__);
        }
        $this->preferredLabel = $preferredLabel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FallbackLabel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
