<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for conceptType StructType
 * @subpackage Structs
 */
class ConceptType extends AbstractStructBase
{
    /**
     * The uri
     * @var string
     */
    public $uri;
    /**
     * The identifier
     * @var string
     */
    public $identifier;
    /**
     * The preferredLabel
     * @var string
     */
    public $preferredLabel;
    /**
     * The fallbackLabel
     * @var \StructType\FallbackLabel
     */
    public $fallbackLabel;
    /**
     * Constructor method for conceptType
     * @uses ConceptType::setUri()
     * @uses ConceptType::setIdentifier()
     * @uses ConceptType::setPreferredLabel()
     * @uses ConceptType::setFallbackLabel()
     * @param string $uri
     * @param string $identifier
     * @param string $preferredLabel
     * @param \StructType\FallbackLabel $fallbackLabel
     */
    public function __construct($uri = null, $identifier = null, $preferredLabel = null, \StructType\FallbackLabel $fallbackLabel = null)
    {
        $this
            ->setUri($uri)
            ->setIdentifier($identifier)
            ->setPreferredLabel($preferredLabel)
            ->setFallbackLabel($fallbackLabel);
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\ConceptType
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \StructType\ConceptType
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get preferredLabel value
     * @return string|null
     */
    public function getPreferredLabel()
    {
        return $this->preferredLabel;
    }
    /**
     * Set preferredLabel value
     * @param string $preferredLabel
     * @return \StructType\ConceptType
     */
    public function setPreferredLabel($preferredLabel = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLabel) && !is_string($preferredLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLabel)), __LINE__);
        }
        $this->preferredLabel = $preferredLabel;
        return $this;
    }
    /**
     * Get fallbackLabel value
     * @return \StructType\FallbackLabel|null
     */
    public function getFallbackLabel()
    {
        return $this->fallbackLabel;
    }
    /**
     * Set fallbackLabel value
     * @param \StructType\FallbackLabel $fallbackLabel
     * @return \StructType\ConceptType
     */
    public function setFallbackLabel(\StructType\FallbackLabel $fallbackLabel = null)
    {
        $this->fallbackLabel = $fallbackLabel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConceptType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
