<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Concept StructType
 * @subpackage Structs
 */
class Concept extends AbstractStructBase
{
    /**
     * The ALTLABEL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ALTLABEL;
    /**
     * The ANNOTATION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ANNOTATION
     * @var \StructType\ANNOTATION[]
     */
    public $ANNOTATION;
    /**
     * The COMPACT_URI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $COMPACT_URI;
    /**
     * The FALLBACK
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FALLBACK[]
     */
    public $FALLBACK;
    /**
     * The IDENTIFIER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $IDENTIFIER;
    /**
     * The OP_CODE
     */
    public $OP_CODE;
    /**
     * The PREFLABEL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $PREFLABEL;
    /**
     * The SAMEAS
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: SAMEAS
     * @var \StructType\SAMEAS[]
     */
    public $SAMEAS;
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\URI
     */
    public $URI;
    /**
     * The TYPE
     * Meta informations extracted from the WSDL
     * - fixed: concept
     * - use: optional
     * @var string
     */
    public $TYPE;
    /**
     * Constructor method for Concept
     * @uses Concept::setALTLABEL()
     * @uses Concept::setANNOTATION()
     * @uses Concept::setCOMPACT_URI()
     * @uses Concept::setFALLBACK()
     * @uses Concept::setIDENTIFIER()
     * @uses Concept::setOP_CODE()
     * @uses Concept::setPREFLABEL()
     * @uses Concept::setSAMEAS()
     * @uses Concept::setURI()
     * @uses Concept::setTYPE()
     * @param mixed[] $aLTLABEL
     * @param \StructType\ANNOTATION[] $aNNOTATION
     * @param mixed $cOMPACT_URI
     * @param \StructType\FALLBACK[] $fALLBACK
     * @param mixed $iDENTIFIER
     * @param string $oP_CODE
     * @param mixed $pREFLABEL
     * @param \StructType\SAMEAS[] $sAMEAS
     * @param \StructType\URI $uRI
     * @param string $tYPE
     */
    public function __construct(array $aLTLABEL = array(), array $aNNOTATION = array(), $cOMPACT_URI = null, array $fALLBACK = array(), $iDENTIFIER = null, $oP_CODE = null, $pREFLABEL = null, array $sAMEAS = array(), \StructType\URI $uRI = null, $tYPE = null)
    {
        $this
            ->setALTLABEL($aLTLABEL)
            ->setANNOTATION($aNNOTATION)
            ->setCOMPACT_URI($cOMPACT_URI)
            ->setFALLBACK($fALLBACK)
            ->setIDENTIFIER($iDENTIFIER)
            ->setOP_CODE($oP_CODE)
            ->setPREFLABEL($pREFLABEL)
            ->setSAMEAS($sAMEAS)
            ->setURI($uRI)
            ->setTYPE($tYPE);
    }
    /**
     * Get ALTLABEL value
     * @return mixed[]|null
     */
    public function getALTLABEL()
    {
        return $this->ALTLABEL;
    }
    /**
     * Set ALTLABEL value
     * @throws \InvalidArgumentException
     * @param mixed[] $aLTLABEL
     * @return \StructType\Concept
     */
    public function setALTLABEL(array $aLTLABEL = array())
    {
        foreach ($aLTLABEL as $conceptALTLABELItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The ALTLABEL property can only contain items of anyType, "%s" given', is_object($conceptALTLABELItem) ? get_class($conceptALTLABELItem) : gettype($conceptALTLABELItem)), __LINE__);
            }
        }
        $this->ALTLABEL = $aLTLABEL;
        return $this;
    }
    /**
     * Add item to ALTLABEL value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Concept
     */
    public function addToALTLABEL($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The ALTLABEL property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ALTLABEL[] = $item;
        return $this;
    }
    /**
     * Get ANNOTATION value
     * @return \StructType\ANNOTATION[]|null
     */
    public function getANNOTATION()
    {
        return $this->ANNOTATION;
    }
    /**
     * Set ANNOTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\ANNOTATION[] $aNNOTATION
     * @return \StructType\Concept
     */
    public function setANNOTATION(array $aNNOTATION = array())
    {
        foreach ($aNNOTATION as $conceptANNOTATIONItem) {
            // validation for constraint: itemType
            if (!$conceptANNOTATIONItem instanceof \StructType\ANNOTATION) {
                throw new \InvalidArgumentException(sprintf('The ANNOTATION property can only contain items of \StructType\ANNOTATION, "%s" given', is_object($conceptANNOTATIONItem) ? get_class($conceptANNOTATIONItem) : gettype($conceptANNOTATIONItem)), __LINE__);
            }
        }
        $this->ANNOTATION = $aNNOTATION;
        return $this;
    }
    /**
     * Add item to ANNOTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\ANNOTATION $item
     * @return \StructType\Concept
     */
    public function addToANNOTATION(\StructType\ANNOTATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ANNOTATION) {
            throw new \InvalidArgumentException(sprintf('The ANNOTATION property can only contain items of \StructType\ANNOTATION, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ANNOTATION[] = $item;
        return $this;
    }
    /**
     * Get COMPACT_URI value
     * @return mixed|null
     */
    public function getCOMPACT_URI()
    {
        return $this->COMPACT_URI;
    }
    /**
     * Set COMPACT_URI value
     * @param mixed $cOMPACT_URI
     * @return \StructType\Concept
     */
    public function setCOMPACT_URI($cOMPACT_URI = null)
    {
        $this->COMPACT_URI = $cOMPACT_URI;
        return $this;
    }
    /**
     * Get FALLBACK value
     * @return \StructType\FALLBACK[]|null
     */
    public function getFALLBACK()
    {
        return $this->FALLBACK;
    }
    /**
     * Set FALLBACK value
     * @throws \InvalidArgumentException
     * @param \StructType\FALLBACK[] $fALLBACK
     * @return \StructType\Concept
     */
    public function setFALLBACK(array $fALLBACK = array())
    {
        foreach ($fALLBACK as $conceptFALLBACKItem) {
            // validation for constraint: itemType
            if (!$conceptFALLBACKItem instanceof \StructType\FALLBACK) {
                throw new \InvalidArgumentException(sprintf('The FALLBACK property can only contain items of \StructType\FALLBACK, "%s" given', is_object($conceptFALLBACKItem) ? get_class($conceptFALLBACKItem) : gettype($conceptFALLBACKItem)), __LINE__);
            }
        }
        $this->FALLBACK = $fALLBACK;
        return $this;
    }
    /**
     * Add item to FALLBACK value
     * @throws \InvalidArgumentException
     * @param \StructType\FALLBACK $item
     * @return \StructType\Concept
     */
    public function addToFALLBACK(\StructType\FALLBACK $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FALLBACK) {
            throw new \InvalidArgumentException(sprintf('The FALLBACK property can only contain items of \StructType\FALLBACK, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FALLBACK[] = $item;
        return $this;
    }
    /**
     * Get IDENTIFIER value
     * @return mixed|null
     */
    public function getIDENTIFIER()
    {
        return $this->IDENTIFIER;
    }
    /**
     * Set IDENTIFIER value
     * @param mixed $iDENTIFIER
     * @return \StructType\Concept
     */
    public function setIDENTIFIER($iDENTIFIER = null)
    {
        $this->IDENTIFIER = $iDENTIFIER;
        return $this;
    }
    /**
     * Get oP_CODE value
     * @return oP_CODE
     */
    public function getOP_CODE()
    {
        return $this->{'OP-CODE'};
    }
    /**
     * Set oP_CODE value
     * @param oP_CODE $oP_CODE
     * @return \StructType\Concept
     */
    public function setOP_CODE($oP_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($oP_CODE) && !is_string($oP_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oP_CODE)), __LINE__);
        }
        $this->OP_CODE = $this->{'OP-CODE'} = $oP_CODE;
        return $this;
    }
    /**
     * Get PREFLABEL value
     * @return mixed|null
     */
    public function getPREFLABEL()
    {
        return $this->PREFLABEL;
    }
    /**
     * Set PREFLABEL value
     * @param mixed $pREFLABEL
     * @return \StructType\Concept
     */
    public function setPREFLABEL($pREFLABEL = null)
    {
        $this->PREFLABEL = $pREFLABEL;
        return $this;
    }
    /**
     * Get SAMEAS value
     * @return \StructType\SAMEAS[]|null
     */
    public function getSAMEAS()
    {
        return $this->SAMEAS;
    }
    /**
     * Set SAMEAS value
     * @throws \InvalidArgumentException
     * @param \StructType\SAMEAS[] $sAMEAS
     * @return \StructType\Concept
     */
    public function setSAMEAS(array $sAMEAS = array())
    {
        foreach ($sAMEAS as $conceptSAMEASItem) {
            // validation for constraint: itemType
            if (!$conceptSAMEASItem instanceof \StructType\SAMEAS) {
                throw new \InvalidArgumentException(sprintf('The SAMEAS property can only contain items of \StructType\SAMEAS, "%s" given', is_object($conceptSAMEASItem) ? get_class($conceptSAMEASItem) : gettype($conceptSAMEASItem)), __LINE__);
            }
        }
        $this->SAMEAS = $sAMEAS;
        return $this;
    }
    /**
     * Add item to SAMEAS value
     * @throws \InvalidArgumentException
     * @param \StructType\SAMEAS $item
     * @return \StructType\Concept
     */
    public function addToSAMEAS(\StructType\SAMEAS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SAMEAS) {
            throw new \InvalidArgumentException(sprintf('The SAMEAS property can only contain items of \StructType\SAMEAS, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SAMEAS[] = $item;
        return $this;
    }
    /**
     * Get URI value
     * @return \StructType\URI|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param \StructType\URI $uRI
     * @return \StructType\Concept
     */
    public function setURI(\StructType\URI $uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\Concept
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tYPE, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Concept
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
