<?php

namespace EnumType;

/**
 * This class stands for type EnumType
 * @subpackage Enumerations
 */
class Type
{
    /**
     * Constant for value 'indexing'
     * @return string 'indexing'
     */
    const VALUE_INDEXING = 'indexing';
    /**
     * Constant for value 'identifier'
     * @return string 'identifier'
     */
    const VALUE_IDENTIFIER = 'identifier';
    /**
     * Constant for value 'object'
     * @return string 'object'
     */
    const VALUE_OBJECT = 'object';
    /**
     * Constant for value 'tree'
     * @return string 'tree'
     */
    const VALUE_TREE = 'tree';
    /**
     * Constant for value 'branch'
     * @return string 'branch'
     */
    const VALUE_BRANCH = 'branch';
    /**
     * Constant for value 'data'
     * @return string 'data'
     */
    const VALUE_DATA = 'data';
    /**
     * Constant for value 'link'
     * @return string 'link'
     */
    const VALUE_LINK = 'link';
    /**
     * Constant for value 'date'
     * @return string 'date'
     */
    const VALUE_DATE = 'date';
    /**
     * Constant for value 'concept'
     * @return string 'concept'
     */
    const VALUE_CONCEPT = 'concept';
    /**
     * Constant for value 'memberlist'
     * @return string 'memberlist'
     */
    const VALUE_MEMBERLIST = 'memberlist';
    /**
     * Constant for value 'concept_level'
     * @return string 'concept_level'
     */
    const VALUE_CONCEPT_LEVEL = 'concept_level';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INDEXING
     * @uses self::VALUE_IDENTIFIER
     * @uses self::VALUE_OBJECT
     * @uses self::VALUE_TREE
     * @uses self::VALUE_BRANCH
     * @uses self::VALUE_DATA
     * @uses self::VALUE_LINK
     * @uses self::VALUE_DATE
     * @uses self::VALUE_CONCEPT
     * @uses self::VALUE_MEMBERLIST
     * @uses self::VALUE_CONCEPT_LEVEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INDEXING,
            self::VALUE_IDENTIFIER,
            self::VALUE_OBJECT,
            self::VALUE_TREE,
            self::VALUE_BRANCH,
            self::VALUE_DATA,
            self::VALUE_LINK,
            self::VALUE_DATE,
            self::VALUE_CONCEPT,
            self::VALUE_MEMBERLIST,
            self::VALUE_CONCEPT_LEVEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
