<?php

namespace EnumType;

/**
 * This class stands for queryErrorType EnumType
 * @subpackage Enumerations
 */
class QueryErrorType
{
    /**
     * Constant for value 'WS_INTERNAL_ERROR'
     * @return string 'WS_INTERNAL_ERROR'
     */
    const VALUE_WS_INTERNAL_ERROR = 'WS_INTERNAL_ERROR';
    /**
     * Constant for value 'WS_QUERY_SYNTAX_ERROR'
     * @return string 'WS_QUERY_SYNTAX_ERROR'
     */
    const VALUE_WS_QUERY_SYNTAX_ERROR = 'WS_QUERY_SYNTAX_ERROR';
    /**
     * Constant for value 'WS_ERROR_ON_STOP_WORD'
     * @return string 'WS_ERROR_ON_STOP_WORD'
     */
    const VALUE_WS_ERROR_ON_STOP_WORD = 'WS_ERROR_ON_STOP_WORD';
    /**
     * Constant for value 'WS_MAXIMUM_NB_OF_WS_CALLS'
     * @return string 'WS_MAXIMUM_NB_OF_WS_CALLS'
     */
    const VALUE_WS_MAXIMUM_NB_OF_WS_CALLS = 'WS_MAXIMUM_NB_OF_WS_CALLS';
    /**
     * Constant for value 'WS_STATUS_NOT_AVAILABLE'
     * @return string 'WS_STATUS_NOT_AVAILABLE'
     */
    const VALUE_WS_STATUS_NOT_AVAILABLE = 'WS_STATUS_NOT_AVAILABLE';
    /**
     * Constant for value 'WS_PAGE_SIZE_TOO_BIG'
     * @return string 'WS_PAGE_SIZE_TOO_BIG'
     */
    const VALUE_WS_PAGE_SIZE_TOO_BIG = 'WS_PAGE_SIZE_TOO_BIG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WS_INTERNAL_ERROR
     * @uses self::VALUE_WS_QUERY_SYNTAX_ERROR
     * @uses self::VALUE_WS_ERROR_ON_STOP_WORD
     * @uses self::VALUE_WS_MAXIMUM_NB_OF_WS_CALLS
     * @uses self::VALUE_WS_STATUS_NOT_AVAILABLE
     * @uses self::VALUE_WS_PAGE_SIZE_TOO_BIG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WS_INTERNAL_ERROR,
            self::VALUE_WS_QUERY_SYNTAX_ERROR,
            self::VALUE_WS_ERROR_ON_STOP_WORD,
            self::VALUE_WS_MAXIMUM_NB_OF_WS_CALLS,
            self::VALUE_WS_STATUS_NOT_AVAILABLE,
            self::VALUE_WS_PAGE_SIZE_TOO_BIG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
