<?php

namespace EnumType;

/**
 * This class stands for mdtypes EnumType
 * @subpackage Enumerations
 */
class Mdtypes
{
    /**
     * Constant for value 'string'
     * @return string 'string'
     */
    const VALUE_STRING = 'string';
    /**
     * Constant for value 'boolean'
     * @return string 'boolean'
     */
    const VALUE_BOOLEAN = 'boolean';
    /**
     * Constant for value 'decimal'
     * @return string 'decimal'
     */
    const VALUE_DECIMAL = 'decimal';
    /**
     * Constant for value 'float'
     * @return string 'float'
     */
    const VALUE_FLOAT = 'float';
    /**
     * Constant for value 'double'
     * @return string 'double'
     */
    const VALUE_DOUBLE = 'double';
    /**
     * Constant for value 'dateTime'
     * @return string 'dateTime'
     */
    const VALUE_DATE_TIME = 'dateTime';
    /**
     * Constant for value 'time'
     * @return string 'time'
     */
    const VALUE_TIME = 'time';
    /**
     * Constant for value 'date'
     * @return string 'date'
     */
    const VALUE_DATE = 'date';
    /**
     * Constant for value 'gYearMonth'
     * @return string 'gYearMonth'
     */
    const VALUE_G_YEAR_MONTH = 'gYearMonth';
    /**
     * Constant for value 'gYear'
     * @return string 'gYear'
     */
    const VALUE_G_YEAR = 'gYear';
    /**
     * Constant for value 'gMonthDay'
     * @return string 'gMonthDay'
     */
    const VALUE_G_MONTH_DAY = 'gMonthDay';
    /**
     * Constant for value 'gDay'
     * @return string 'gDay'
     */
    const VALUE_G_DAY = 'gDay';
    /**
     * Constant for value 'gMonth'
     * @return string 'gMonth'
     */
    const VALUE_G_MONTH = 'gMonth';
    /**
     * Constant for value 'hexBinary'
     * @return string 'hexBinary'
     */
    const VALUE_HEX_BINARY = 'hexBinary';
    /**
     * Constant for value 'base64Binary'
     * @return string 'base64Binary'
     */
    const VALUE_BASE_64_BINARY = 'base64Binary';
    /**
     * Constant for value 'anyURI'
     * @return string 'anyURI'
     */
    const VALUE_ANY_URI = 'anyURI';
    /**
     * Constant for value 'normalizedString'
     * @return string 'normalizedString'
     */
    const VALUE_NORMALIZED_STRING = 'normalizedString';
    /**
     * Constant for value 'token'
     * @return string 'token'
     */
    const VALUE_TOKEN = 'token';
    /**
     * Constant for value 'language'
     * @return string 'language'
     */
    const VALUE_LANGUAGE = 'language';
    /**
     * Constant for value 'NMTOKEN'
     * @return string 'NMTOKEN'
     */
    const VALUE_NMTOKEN = 'NMTOKEN';
    /**
     * Constant for value 'Name'
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Constant for value 'NCName'
     * @return string 'NCName'
     */
    const VALUE_NCNAME = 'NCName';
    /**
     * Constant for value 'integer'
     * @return string 'integer'
     */
    const VALUE_INTEGER = 'integer';
    /**
     * Constant for value 'nonPositiveInteger'
     * @return string 'nonPositiveInteger'
     */
    const VALUE_NON_POSITIVE_INTEGER = 'nonPositiveInteger';
    /**
     * Constant for value 'negativeInteger'
     * @return string 'negativeInteger'
     */
    const VALUE_NEGATIVE_INTEGER = 'negativeInteger';
    /**
     * Constant for value 'long'
     * @return string 'long'
     */
    const VALUE_LONG = 'long';
    /**
     * Constant for value 'int'
     * @return string 'int'
     */
    const VALUE_INT = 'int';
    /**
     * Constant for value 'short'
     * @return string 'short'
     */
    const VALUE_SHORT = 'short';
    /**
     * Constant for value 'byte'
     * @return string 'byte'
     */
    const VALUE_BYTE = 'byte';
    /**
     * Constant for value 'nonNegativeInteger'
     * @return string 'nonNegativeInteger'
     */
    const VALUE_NON_NEGATIVE_INTEGER = 'nonNegativeInteger';
    /**
     * Constant for value 'unsignedLong'
     * @return string 'unsignedLong'
     */
    const VALUE_UNSIGNED_LONG = 'unsignedLong';
    /**
     * Constant for value 'unsignedInt'
     * @return string 'unsignedInt'
     */
    const VALUE_UNSIGNED_INT = 'unsignedInt';
    /**
     * Constant for value 'unsignedShort'
     * @return string 'unsignedShort'
     */
    const VALUE_UNSIGNED_SHORT = 'unsignedShort';
    /**
     * Constant for value 'unsignedByte'
     * @return string 'unsignedByte'
     */
    const VALUE_UNSIGNED_BYTE = 'unsignedByte';
    /**
     * Constant for value 'positiveInteger'
     * @return string 'positiveInteger'
     */
    const VALUE_POSITIVE_INTEGER = 'positiveInteger';
    /**
     * Constant for value 'PlainLiteral'
     * @return string 'PlainLiteral'
     */
    const VALUE_PLAIN_LITERAL = 'PlainLiteral';
    /**
     * Constant for value 'XMLLiteral'
     * @return string 'XMLLiteral'
     */
    const VALUE_XMLLITERAL = 'XMLLiteral';
    /**
     * Constant for value 'Literal'
     * @return string 'Literal'
     */
    const VALUE_LITERAL = 'Literal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STRING
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_FLOAT
     * @uses self::VALUE_DOUBLE
     * @uses self::VALUE_DATE_TIME
     * @uses self::VALUE_TIME
     * @uses self::VALUE_DATE
     * @uses self::VALUE_G_YEAR_MONTH
     * @uses self::VALUE_G_YEAR
     * @uses self::VALUE_G_MONTH_DAY
     * @uses self::VALUE_G_DAY
     * @uses self::VALUE_G_MONTH
     * @uses self::VALUE_HEX_BINARY
     * @uses self::VALUE_BASE_64_BINARY
     * @uses self::VALUE_ANY_URI
     * @uses self::VALUE_NORMALIZED_STRING
     * @uses self::VALUE_TOKEN
     * @uses self::VALUE_LANGUAGE
     * @uses self::VALUE_NMTOKEN
     * @uses self::VALUE_NAME
     * @uses self::VALUE_NCNAME
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_NON_POSITIVE_INTEGER
     * @uses self::VALUE_NEGATIVE_INTEGER
     * @uses self::VALUE_LONG
     * @uses self::VALUE_INT
     * @uses self::VALUE_SHORT
     * @uses self::VALUE_BYTE
     * @uses self::VALUE_NON_NEGATIVE_INTEGER
     * @uses self::VALUE_UNSIGNED_LONG
     * @uses self::VALUE_UNSIGNED_INT
     * @uses self::VALUE_UNSIGNED_SHORT
     * @uses self::VALUE_UNSIGNED_BYTE
     * @uses self::VALUE_POSITIVE_INTEGER
     * @uses self::VALUE_PLAIN_LITERAL
     * @uses self::VALUE_XMLLITERAL
     * @uses self::VALUE_LITERAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STRING,
            self::VALUE_BOOLEAN,
            self::VALUE_DECIMAL,
            self::VALUE_FLOAT,
            self::VALUE_DOUBLE,
            self::VALUE_DATE_TIME,
            self::VALUE_TIME,
            self::VALUE_DATE,
            self::VALUE_G_YEAR_MONTH,
            self::VALUE_G_YEAR,
            self::VALUE_G_MONTH_DAY,
            self::VALUE_G_DAY,
            self::VALUE_G_MONTH,
            self::VALUE_HEX_BINARY,
            self::VALUE_BASE_64_BINARY,
            self::VALUE_ANY_URI,
            self::VALUE_NORMALIZED_STRING,
            self::VALUE_TOKEN,
            self::VALUE_LANGUAGE,
            self::VALUE_NMTOKEN,
            self::VALUE_NAME,
            self::VALUE_NCNAME,
            self::VALUE_INTEGER,
            self::VALUE_NON_POSITIVE_INTEGER,
            self::VALUE_NEGATIVE_INTEGER,
            self::VALUE_LONG,
            self::VALUE_INT,
            self::VALUE_SHORT,
            self::VALUE_BYTE,
            self::VALUE_NON_NEGATIVE_INTEGER,
            self::VALUE_UNSIGNED_LONG,
            self::VALUE_UNSIGNED_INT,
            self::VALUE_UNSIGNED_SHORT,
            self::VALUE_UNSIGNED_BYTE,
            self::VALUE_POSITIVE_INTEGER,
            self::VALUE_PLAIN_LITERAL,
            self::VALUE_XMLLITERAL,
            self::VALUE_LITERAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
