<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Relation StructType
 * @subpackage Structs
 */
class Relation extends AbstractStructBase
{
    /**
     * The ALTLABEL
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ALTLABEL;
    /**
     * The ANNOTATION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ANNOTATION
     * @var \StructType\ANNOTATION[]
     */
    public $ANNOTATION;
    /**
     * The EMBEDDED_NOTICE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EMBEDDED_NOTICEType
     */
    public $EMBEDDED_NOTICE;
    /**
     * The IDENTIFIER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDENTIFIER;
    /**
     * The PREFLABEL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $PREFLABEL;
    /**
     * The SAMEAS
     * @var \StructType\SAMEAS
     */
    public $SAMEAS;
    /**
     * The URI
     * @var \StructType\URI
     */
    public $URI;
    /**
     * The TYPE
     * Meta informations extracted from the WSDL
     * - fixed: link
     * - use: optional
     * @var string
     */
    public $TYPE;
    /**
     * Constructor method for Relation
     * @uses Relation::setALTLABEL()
     * @uses Relation::setANNOTATION()
     * @uses Relation::setEMBEDDED_NOTICE()
     * @uses Relation::setIDENTIFIER()
     * @uses Relation::setPREFLABEL()
     * @uses Relation::setSAMEAS()
     * @uses Relation::setURI()
     * @uses Relation::setTYPE()
     * @param mixed[] $aLTLABEL
     * @param \StructType\ANNOTATION[] $aNNOTATION
     * @param \StructType\EMBEDDED_NOTICEType $eMBEDDED_NOTICE
     * @param string $iDENTIFIER
     * @param mixed $pREFLABEL
     * @param \StructType\SAMEAS $sAMEAS
     * @param \StructType\URI $uRI
     * @param string $tYPE
     */
    public function __construct(array $aLTLABEL = array(), array $aNNOTATION = array(), \StructType\EMBEDDED_NOTICEType $eMBEDDED_NOTICE = null, $iDENTIFIER = null, $pREFLABEL = null, \StructType\SAMEAS $sAMEAS = null, \StructType\URI $uRI = null, $tYPE = null)
    {
        $this
            ->setALTLABEL($aLTLABEL)
            ->setANNOTATION($aNNOTATION)
            ->setEMBEDDED_NOTICE($eMBEDDED_NOTICE)
            ->setIDENTIFIER($iDENTIFIER)
            ->setPREFLABEL($pREFLABEL)
            ->setSAMEAS($sAMEAS)
            ->setURI($uRI)
            ->setTYPE($tYPE);
    }
    /**
     * Get ALTLABEL value
     * @return mixed[]|null
     */
    public function getALTLABEL()
    {
        return $this->ALTLABEL;
    }
    /**
     * Set ALTLABEL value
     * @throws \InvalidArgumentException
     * @param mixed[] $aLTLABEL
     * @return \StructType\Relation
     */
    public function setALTLABEL(array $aLTLABEL = array())
    {
        foreach ($aLTLABEL as $relationALTLABELItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The ALTLABEL property can only contain items of anyType, "%s" given', is_object($relationALTLABELItem) ? get_class($relationALTLABELItem) : gettype($relationALTLABELItem)), __LINE__);
            }
        }
        $this->ALTLABEL = $aLTLABEL;
        return $this;
    }
    /**
     * Add item to ALTLABEL value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Relation
     */
    public function addToALTLABEL($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The ALTLABEL property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ALTLABEL[] = $item;
        return $this;
    }
    /**
     * Get ANNOTATION value
     * @return \StructType\ANNOTATION[]|null
     */
    public function getANNOTATION()
    {
        return $this->ANNOTATION;
    }
    /**
     * Set ANNOTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\ANNOTATION[] $aNNOTATION
     * @return \StructType\Relation
     */
    public function setANNOTATION(array $aNNOTATION = array())
    {
        foreach ($aNNOTATION as $relationANNOTATIONItem) {
            // validation for constraint: itemType
            if (!$relationANNOTATIONItem instanceof \StructType\ANNOTATION) {
                throw new \InvalidArgumentException(sprintf('The ANNOTATION property can only contain items of \StructType\ANNOTATION, "%s" given', is_object($relationANNOTATIONItem) ? get_class($relationANNOTATIONItem) : gettype($relationANNOTATIONItem)), __LINE__);
            }
        }
        $this->ANNOTATION = $aNNOTATION;
        return $this;
    }
    /**
     * Add item to ANNOTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\ANNOTATION $item
     * @return \StructType\Relation
     */
    public function addToANNOTATION(\StructType\ANNOTATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ANNOTATION) {
            throw new \InvalidArgumentException(sprintf('The ANNOTATION property can only contain items of \StructType\ANNOTATION, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ANNOTATION[] = $item;
        return $this;
    }
    /**
     * Get EMBEDDED_NOTICE value
     * @return \StructType\EMBEDDED_NOTICEType|null
     */
    public function getEMBEDDED_NOTICE()
    {
        return $this->EMBEDDED_NOTICE;
    }
    /**
     * Set EMBEDDED_NOTICE value
     * @param \StructType\EMBEDDED_NOTICEType $eMBEDDED_NOTICE
     * @return \StructType\Relation
     */
    public function setEMBEDDED_NOTICE(\StructType\EMBEDDED_NOTICEType $eMBEDDED_NOTICE = null)
    {
        $this->EMBEDDED_NOTICE = $eMBEDDED_NOTICE;
        return $this;
    }
    /**
     * Get IDENTIFIER value
     * @return string|null
     */
    public function getIDENTIFIER()
    {
        return $this->IDENTIFIER;
    }
    /**
     * Set IDENTIFIER value
     * @param string $iDENTIFIER
     * @return \StructType\Relation
     */
    public function setIDENTIFIER($iDENTIFIER = null)
    {
        // validation for constraint: string
        if (!is_null($iDENTIFIER) && !is_string($iDENTIFIER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDENTIFIER)), __LINE__);
        }
        $this->IDENTIFIER = $iDENTIFIER;
        return $this;
    }
    /**
     * Get PREFLABEL value
     * @return mixed|null
     */
    public function getPREFLABEL()
    {
        return $this->PREFLABEL;
    }
    /**
     * Set PREFLABEL value
     * @param mixed $pREFLABEL
     * @return \StructType\Relation
     */
    public function setPREFLABEL($pREFLABEL = null)
    {
        $this->PREFLABEL = $pREFLABEL;
        return $this;
    }
    /**
     * Get SAMEAS value
     * @return \StructType\SAMEAS|null
     */
    public function getSAMEAS()
    {
        return $this->SAMEAS;
    }
    /**
     * Set SAMEAS value
     * @param \StructType\SAMEAS $sAMEAS
     * @return \StructType\Relation
     */
    public function setSAMEAS(\StructType\SAMEAS $sAMEAS = null)
    {
        $this->SAMEAS = $sAMEAS;
        return $this;
    }
    /**
     * Get URI value
     * @return \StructType\URI|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param \StructType\URI $uRI
     * @return \StructType\Relation
     */
    public function setURI(\StructType\URI $uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\Relation
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tYPE, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Relation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
