<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMBEDDED_NOTICEType StructType
 * @subpackage Structs
 */
class EMBEDDED_NOTICEType extends AbstractStructBase
{
    /**
     * The AGENT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmbeddedAgentType
     */
    public $AGENT;
    /**
     * The DOSSIER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmbeddedDossierType
     */
    public $DOSSIER;
    /**
     * The EXPRESSION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmbeddedExpressionType[]
     */
    public $EXPRESSION;
    /**
     * The INVERSE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InverseType
     */
    public $INVERSE;
    /**
     * The MANIFESTATION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmbeddedManifestationType[]
     */
    public $MANIFESTATION;
    /**
     * The WORK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmbeddedWorkType
     */
    public $WORK;
    /**
     * Constructor method for EMBEDDED_NOTICEType
     * @uses EMBEDDED_NOTICEType::setAGENT()
     * @uses EMBEDDED_NOTICEType::setDOSSIER()
     * @uses EMBEDDED_NOTICEType::setEXPRESSION()
     * @uses EMBEDDED_NOTICEType::setINVERSE()
     * @uses EMBEDDED_NOTICEType::setMANIFESTATION()
     * @uses EMBEDDED_NOTICEType::setWORK()
     * @param \StructType\EmbeddedAgentType $aGENT
     * @param \StructType\EmbeddedDossierType $dOSSIER
     * @param \StructType\EmbeddedExpressionType[] $eXPRESSION
     * @param \StructType\InverseType $iNVERSE
     * @param \StructType\EmbeddedManifestationType[] $mANIFESTATION
     * @param \StructType\EmbeddedWorkType $wORK
     */
    public function __construct(\StructType\EmbeddedAgentType $aGENT = null, \StructType\EmbeddedDossierType $dOSSIER = null, array $eXPRESSION = array(), \StructType\InverseType $iNVERSE = null, array $mANIFESTATION = array(), \StructType\EmbeddedWorkType $wORK = null)
    {
        $this
            ->setAGENT($aGENT)
            ->setDOSSIER($dOSSIER)
            ->setEXPRESSION($eXPRESSION)
            ->setINVERSE($iNVERSE)
            ->setMANIFESTATION($mANIFESTATION)
            ->setWORK($wORK);
    }
    /**
     * Get AGENT value
     * @return \StructType\EmbeddedAgentType|null
     */
    public function getAGENT()
    {
        return $this->AGENT;
    }
    /**
     * Set AGENT value
     * @param \StructType\EmbeddedAgentType $aGENT
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setAGENT(\StructType\EmbeddedAgentType $aGENT = null)
    {
        $this->AGENT = $aGENT;
        return $this;
    }
    /**
     * Get DOSSIER value
     * @return \StructType\EmbeddedDossierType|null
     */
    public function getDOSSIER()
    {
        return $this->DOSSIER;
    }
    /**
     * Set DOSSIER value
     * @param \StructType\EmbeddedDossierType $dOSSIER
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setDOSSIER(\StructType\EmbeddedDossierType $dOSSIER = null)
    {
        $this->DOSSIER = $dOSSIER;
        return $this;
    }
    /**
     * Get EXPRESSION value
     * @return \StructType\EmbeddedExpressionType[]|null
     */
    public function getEXPRESSION()
    {
        return $this->EXPRESSION;
    }
    /**
     * Set EXPRESSION value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedExpressionType[] $eXPRESSION
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setEXPRESSION(array $eXPRESSION = array())
    {
        foreach ($eXPRESSION as $eMBEDDED_NOTICETypeEXPRESSIONItem) {
            // validation for constraint: itemType
            if (!$eMBEDDED_NOTICETypeEXPRESSIONItem instanceof \StructType\EmbeddedExpressionType) {
                throw new \InvalidArgumentException(sprintf('The EXPRESSION property can only contain items of \StructType\EmbeddedExpressionType, "%s" given', is_object($eMBEDDED_NOTICETypeEXPRESSIONItem) ? get_class($eMBEDDED_NOTICETypeEXPRESSIONItem) : gettype($eMBEDDED_NOTICETypeEXPRESSIONItem)), __LINE__);
            }
        }
        $this->EXPRESSION = $eXPRESSION;
        return $this;
    }
    /**
     * Add item to EXPRESSION value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedExpressionType $item
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function addToEXPRESSION(\StructType\EmbeddedExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmbeddedExpressionType) {
            throw new \InvalidArgumentException(sprintf('The EXPRESSION property can only contain items of \StructType\EmbeddedExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EXPRESSION[] = $item;
        return $this;
    }
    /**
     * Get INVERSE value
     * @return \StructType\InverseType|null
     */
    public function getINVERSE()
    {
        return $this->INVERSE;
    }
    /**
     * Set INVERSE value
     * @param \StructType\InverseType $iNVERSE
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setINVERSE(\StructType\InverseType $iNVERSE = null)
    {
        $this->INVERSE = $iNVERSE;
        return $this;
    }
    /**
     * Get MANIFESTATION value
     * @return \StructType\EmbeddedManifestationType[]|null
     */
    public function getMANIFESTATION()
    {
        return $this->MANIFESTATION;
    }
    /**
     * Set MANIFESTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedManifestationType[] $mANIFESTATION
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setMANIFESTATION(array $mANIFESTATION = array())
    {
        foreach ($mANIFESTATION as $eMBEDDED_NOTICETypeMANIFESTATIONItem) {
            // validation for constraint: itemType
            if (!$eMBEDDED_NOTICETypeMANIFESTATIONItem instanceof \StructType\EmbeddedManifestationType) {
                throw new \InvalidArgumentException(sprintf('The MANIFESTATION property can only contain items of \StructType\EmbeddedManifestationType, "%s" given', is_object($eMBEDDED_NOTICETypeMANIFESTATIONItem) ? get_class($eMBEDDED_NOTICETypeMANIFESTATIONItem) : gettype($eMBEDDED_NOTICETypeMANIFESTATIONItem)), __LINE__);
            }
        }
        $this->MANIFESTATION = $mANIFESTATION;
        return $this;
    }
    /**
     * Add item to MANIFESTATION value
     * @throws \InvalidArgumentException
     * @param \StructType\EmbeddedManifestationType $item
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function addToMANIFESTATION(\StructType\EmbeddedManifestationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmbeddedManifestationType) {
            throw new \InvalidArgumentException(sprintf('The MANIFESTATION property can only contain items of \StructType\EmbeddedManifestationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MANIFESTATION[] = $item;
        return $this;
    }
    /**
     * Get WORK value
     * @return \StructType\EmbeddedWorkType|null
     */
    public function getWORK()
    {
        return $this->WORK;
    }
    /**
     * Set WORK value
     * @param \StructType\EmbeddedWorkType $wORK
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public function setWORK(\StructType\EmbeddedWorkType $wORK = null)
    {
        $this->WORK = $wORK;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EMBEDDED_NOTICEType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
