<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchRequest StructType
 * @subpackage Structs
 */
class SearchRequest extends AbstractStructBase
{
    /**
     * The expertQuery
     * @var string
     */
    public $expertQuery;
    /**
     * The page
     * @var int
     */
    public $page;
    /**
     * The pageSize
     * @var int
     */
    public $pageSize;
    /**
     * The searchLanguage
     * @var string
     */
    public $searchLanguage;
    /**
     * The limitToLatestConsleg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $limitToLatestConsleg;
    /**
     * The excludeAllConsleg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $excludeAllConsleg;
    /**
     * Constructor method for searchRequest
     * @uses SearchRequest::setExpertQuery()
     * @uses SearchRequest::setPage()
     * @uses SearchRequest::setPageSize()
     * @uses SearchRequest::setSearchLanguage()
     * @uses SearchRequest::setLimitToLatestConsleg()
     * @uses SearchRequest::setExcludeAllConsleg()
     * @param string $expertQuery
     * @param int $page
     * @param int $pageSize
     * @param string $searchLanguage
     * @param string $limitToLatestConsleg
     * @param string $excludeAllConsleg
     */
    public function __construct($expertQuery = null, $page = null, $pageSize = null, $searchLanguage = null, $limitToLatestConsleg = null, $excludeAllConsleg = null)
    {
        $this
            ->setExpertQuery($expertQuery)
            ->setPage($page)
            ->setPageSize($pageSize)
            ->setSearchLanguage($searchLanguage)
            ->setLimitToLatestConsleg($limitToLatestConsleg)
            ->setExcludeAllConsleg($excludeAllConsleg);
    }
    /**
     * Get expertQuery value
     * @return string|null
     */
    public function getExpertQuery()
    {
        return $this->expertQuery;
    }
    /**
     * Set expertQuery value
     * @param string $expertQuery
     * @return \StructType\SearchRequest
     */
    public function setExpertQuery($expertQuery = null)
    {
        // validation for constraint: string
        if (!is_null($expertQuery) && !is_string($expertQuery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expertQuery)), __LINE__);
        }
        $this->expertQuery = $expertQuery;
        return $this;
    }
    /**
     * Get page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param int $page
     * @return \StructType\SearchRequest
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\SearchRequest
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get searchLanguage value
     * @return string|null
     */
    public function getSearchLanguage()
    {
        return $this->searchLanguage;
    }
    /**
     * Set searchLanguage value
     * @uses \EnumType\SearchLanguageType::valueIsValid()
     * @uses \EnumType\SearchLanguageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchLanguage
     * @return \StructType\SearchRequest
     */
    public function setSearchLanguage($searchLanguage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchLanguageType::valueIsValid($searchLanguage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchLanguage, implode(', ', \EnumType\SearchLanguageType::getValidValues())), __LINE__);
        }
        $this->searchLanguage = $searchLanguage;
        return $this;
    }
    /**
     * Get limitToLatestConsleg value
     * @return string|null
     */
    public function getLimitToLatestConsleg()
    {
        return $this->limitToLatestConsleg;
    }
    /**
     * Set limitToLatestConsleg value
     * @param string $limitToLatestConsleg
     * @return \StructType\SearchRequest
     */
    public function setLimitToLatestConsleg($limitToLatestConsleg = null)
    {
        // validation for constraint: string
        if (!is_null($limitToLatestConsleg) && !is_string($limitToLatestConsleg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($limitToLatestConsleg)), __LINE__);
        }
        $this->limitToLatestConsleg = $limitToLatestConsleg;
        return $this;
    }
    /**
     * Get excludeAllConsleg value
     * @return string|null
     */
    public function getExcludeAllConsleg()
    {
        return $this->excludeAllConsleg;
    }
    /**
     * Set excludeAllConsleg value
     * @param string $excludeAllConsleg
     * @return \StructType\SearchRequest
     */
    public function setExcludeAllConsleg($excludeAllConsleg = null)
    {
        // validation for constraint: string
        if (!is_null($excludeAllConsleg) && !is_string($excludeAllConsleg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($excludeAllConsleg)), __LINE__);
        }
        $this->excludeAllConsleg = $excludeAllConsleg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
