<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTICE StructType
 * @subpackage Structs
 */
class NOTICE extends AbstractStructBase
{
    /**
     * The EXPRESSION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExpressionType[]
     */
    public $EXPRESSION;
    /**
     * The INVERSE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InverseType
     */
    public $INVERSE;
    /**
     * The MANIFESTATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManifestationType
     */
    public $MANIFESTATION;
    /**
     * The WORK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WorkType
     */
    public $WORK;
    /**
     * The DOSSIER
     * @var \StructType\DossierType
     */
    public $DOSSIER;
    /**
     * The EVENT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventType[]
     */
    public $EVENT;
    /**
     * The decoding
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var UNKNOWN
     */
    public $decoding;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for NOTICE
     * @uses NOTICE::setEXPRESSION()
     * @uses NOTICE::setINVERSE()
     * @uses NOTICE::setMANIFESTATION()
     * @uses NOTICE::setWORK()
     * @uses NOTICE::setDOSSIER()
     * @uses NOTICE::setEVENT()
     * @uses NOTICE::setDecoding()
     * @uses NOTICE::setType()
     * @param \StructType\ExpressionType[] $eXPRESSION
     * @param \StructType\InverseType $iNVERSE
     * @param \StructType\ManifestationType $mANIFESTATION
     * @param \StructType\WorkType $wORK
     * @param \StructType\DossierType $dOSSIER
     * @param \StructType\EventType[] $eVENT
     * @param UNKNOWN $decoding
     * @param string $type
     */
    public function __construct(array $eXPRESSION = array(), \StructType\InverseType $iNVERSE = null, \StructType\ManifestationType $mANIFESTATION = null, \StructType\WorkType $wORK = null, \StructType\DossierType $dOSSIER = null, array $eVENT = array(), UNKNOWN $decoding = null, $type = null)
    {
        $this
            ->setEXPRESSION($eXPRESSION)
            ->setINVERSE($iNVERSE)
            ->setMANIFESTATION($mANIFESTATION)
            ->setWORK($wORK)
            ->setDOSSIER($dOSSIER)
            ->setEVENT($eVENT)
            ->setDecoding($decoding)
            ->setType($type);
    }
    /**
     * Get EXPRESSION value
     * @return \StructType\ExpressionType[]|null
     */
    public function getEXPRESSION()
    {
        return $this->EXPRESSION;
    }
    /**
     * Set EXPRESSION value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpressionType[] $eXPRESSION
     * @return \StructType\NOTICE
     */
    public function setEXPRESSION(array $eXPRESSION = array())
    {
        foreach ($eXPRESSION as $nOTICEEXPRESSIONItem) {
            // validation for constraint: itemType
            if (!$nOTICEEXPRESSIONItem instanceof \StructType\ExpressionType) {
                throw new \InvalidArgumentException(sprintf('The EXPRESSION property can only contain items of \StructType\ExpressionType, "%s" given', is_object($nOTICEEXPRESSIONItem) ? get_class($nOTICEEXPRESSIONItem) : gettype($nOTICEEXPRESSIONItem)), __LINE__);
            }
        }
        $this->EXPRESSION = $eXPRESSION;
        return $this;
    }
    /**
     * Add item to EXPRESSION value
     * @throws \InvalidArgumentException
     * @param \StructType\ExpressionType $item
     * @return \StructType\NOTICE
     */
    public function addToEXPRESSION(\StructType\ExpressionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExpressionType) {
            throw new \InvalidArgumentException(sprintf('The EXPRESSION property can only contain items of \StructType\ExpressionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EXPRESSION[] = $item;
        return $this;
    }
    /**
     * Get INVERSE value
     * @return \StructType\InverseType|null
     */
    public function getINVERSE()
    {
        return $this->INVERSE;
    }
    /**
     * Set INVERSE value
     * @param \StructType\InverseType $iNVERSE
     * @return \StructType\NOTICE
     */
    public function setINVERSE(\StructType\InverseType $iNVERSE = null)
    {
        $this->INVERSE = $iNVERSE;
        return $this;
    }
    /**
     * Get MANIFESTATION value
     * @return \StructType\ManifestationType|null
     */
    public function getMANIFESTATION()
    {
        return $this->MANIFESTATION;
    }
    /**
     * Set MANIFESTATION value
     * @param \StructType\ManifestationType $mANIFESTATION
     * @return \StructType\NOTICE
     */
    public function setMANIFESTATION(\StructType\ManifestationType $mANIFESTATION = null)
    {
        $this->MANIFESTATION = $mANIFESTATION;
        return $this;
    }
    /**
     * Get WORK value
     * @return \StructType\WorkType|null
     */
    public function getWORK()
    {
        return $this->WORK;
    }
    /**
     * Set WORK value
     * @param \StructType\WorkType $wORK
     * @return \StructType\NOTICE
     */
    public function setWORK(\StructType\WorkType $wORK = null)
    {
        $this->WORK = $wORK;
        return $this;
    }
    /**
     * Get DOSSIER value
     * @return \StructType\DossierType|null
     */
    public function getDOSSIER()
    {
        return $this->DOSSIER;
    }
    /**
     * Set DOSSIER value
     * @param \StructType\DossierType $dOSSIER
     * @return \StructType\NOTICE
     */
    public function setDOSSIER(\StructType\DossierType $dOSSIER = null)
    {
        $this->DOSSIER = $dOSSIER;
        return $this;
    }
    /**
     * Get EVENT value
     * @return \StructType\EventType[]|null
     */
    public function getEVENT()
    {
        return $this->EVENT;
    }
    /**
     * Set EVENT value
     * @throws \InvalidArgumentException
     * @param \StructType\EventType[] $eVENT
     * @return \StructType\NOTICE
     */
    public function setEVENT(array $eVENT = array())
    {
        foreach ($eVENT as $nOTICEEVENTItem) {
            // validation for constraint: itemType
            if (!$nOTICEEVENTItem instanceof \StructType\EventType) {
                throw new \InvalidArgumentException(sprintf('The EVENT property can only contain items of \StructType\EventType, "%s" given', is_object($nOTICEEVENTItem) ? get_class($nOTICEEVENTItem) : gettype($nOTICEEVENTItem)), __LINE__);
            }
        }
        $this->EVENT = $eVENT;
        return $this;
    }
    /**
     * Add item to EVENT value
     * @throws \InvalidArgumentException
     * @param \StructType\EventType $item
     * @return \StructType\NOTICE
     */
    public function addToEVENT(\StructType\EventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventType) {
            throw new \InvalidArgumentException(sprintf('The EVENT property can only contain items of \StructType\EventType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EVENT[] = $item;
        return $this;
    }
    /**
     * Get decoding value
     * @return UNKNOWN|null
     */
    public function getDecoding()
    {
        return $this->decoding;
    }
    /**
     * Set decoding value
     * @param UNKNOWN $decoding
     * @return \StructType\NOTICE
     */
    public function setDecoding(UNKNOWN $decoding = null)
    {
        $this->decoding = $decoding;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\NOTICE
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NOTICE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
