<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Literal StructType
 * @subpackage Structs
 */
class Literal extends AbstractStructBase
{
    /**
     * The VALUE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $VALUE;
    /**
     * The ANNOTATION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ANNOTATION
     * @var \StructType\ANNOTATION
     */
    public $ANNOTATION;
    /**
     * The TYPE
     * Meta informations extracted from the WSDL
     * - fixed: data
     * - use: optional
     * @var string
     */
    public $TYPE;
    /**
     * The xsdType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $xsdType;
    /**
     * Constructor method for Literal
     * @uses Literal::setVALUE()
     * @uses Literal::setANNOTATION()
     * @uses Literal::setTYPE()
     * @uses Literal::setXsdType()
     * @param mixed $vALUE
     * @param \StructType\ANNOTATION $aNNOTATION
     * @param string $tYPE
     * @param string $xsdType
     */
    public function __construct($vALUE = null, \StructType\ANNOTATION $aNNOTATION = null, $tYPE = null, $xsdType = null)
    {
        $this
            ->setVALUE($vALUE)
            ->setANNOTATION($aNNOTATION)
            ->setTYPE($tYPE)
            ->setXsdType($xsdType);
    }
    /**
     * Get VALUE value
     * @return mixed|null
     */
    public function getVALUE()
    {
        return $this->VALUE;
    }
    /**
     * Set VALUE value
     * @param mixed $vALUE
     * @return \StructType\Literal
     */
    public function setVALUE($vALUE = null)
    {
        $this->VALUE = $vALUE;
        return $this;
    }
    /**
     * Get ANNOTATION value
     * @return \StructType\ANNOTATION|null
     */
    public function getANNOTATION()
    {
        return $this->ANNOTATION;
    }
    /**
     * Set ANNOTATION value
     * @param \StructType\ANNOTATION $aNNOTATION
     * @return \StructType\Literal
     */
    public function setANNOTATION(\StructType\ANNOTATION $aNNOTATION = null)
    {
        $this->ANNOTATION = $aNNOTATION;
        return $this;
    }
    /**
     * Get TYPE value
     * @return string|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @uses \EnumType\Type::valueIsValid()
     * @uses \EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tYPE
     * @return \StructType\Literal
     */
    public function setTYPE($tYPE = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Type::valueIsValid($tYPE)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tYPE, implode(', ', \EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Get xsdType value
     * @return string|null
     */
    public function getXsdType()
    {
        return $this->xsdType;
    }
    /**
     * Set xsdType value
     * @uses \EnumType\Mdtypes::valueIsValid()
     * @uses \EnumType\Mdtypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $xsdType
     * @return \StructType\Literal
     */
    public function setXsdType($xsdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Mdtypes::valueIsValid($xsdType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $xsdType, implode(', ', \EnumType\Mdtypes::getValidValues())), __LINE__);
        }
        $this->xsdType = $xsdType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Literal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
