<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for embeddedWorkType StructType
 * @subpackage Structs
 */
class EmbeddedWorkType extends AbstractStructBase
{
    /**
     * The CONTAINER_CASE_LAW_COURT
     */
    public $CONTAINER_CASE_LAW_COURT;
    /**
     * The CONTAINER_CASE_LAW_FASCICULE
     */
    public $CONTAINER_CASE_LAW_FASCICULE;
    /**
     * The CONTAINER_CASE_LAW_ID_NUMPUB
     */
    public $CONTAINER_CASE_LAW_ID_NUMPUB;
    /**
     * The CONTAINER_CASE_LAW_NUMBER
     */
    public $CONTAINER_CASE_LAW_NUMBER;
    /**
     * The CONTAINER_CASE_LAW_YEAR_DECISION
     */
    public $CONTAINER_CASE_LAW_YEAR_DECISION;
    /**
     * The COURT_REPORT_NUMBER
     */
    public $COURT_REPORT_NUMBER;
    /**
     * The DATE_PUBLICATION
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: DATE_PUBLICATION
     * @var \StructType\Date[]
     */
    public $DATE_PUBLICATION;
    /**
     * The ID_SECTOR
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ID_SECTOR
     * @var \StructType\Literal[]
     */
    public $ID_SECTOR;
    /**
     * The LEGAL_EFFECT_PAPER
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: LEGAL_EFFECT_PAPER
     * @var \StructType\Literal[]
     */
    public $LEGAL_EFFECT_PAPER;
    /**
     * The OFFICIAL_JOURNAL_CLASS
     */
    public $OFFICIAL_JOURNAL_CLASS;
    /**
     * The OFFICIAL_JOURNAL_NUMBER
     */
    public $OFFICIAL_JOURNAL_NUMBER;
    /**
     * The OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT
     */
    public $OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT;
    /**
     * The OFFICIAL_JOURNAL_YEAR
     */
    public $OFFICIAL_JOURNAL_YEAR;
    /**
     * The RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     */
    public $RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE;
    /**
     * The RESOURCE_LEGAL_NUMBER_NATURAL_CELEX
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: RESOURCE_LEGAL_NUMBER_NATURAL_CELEX
     * @var \StructType\Literal[]
     */
    public $RESOURCE_LEGAL_NUMBER_NATURAL_CELEX;
    /**
     * The RESOURCE_LEGAL_TYPE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: RESOURCE_LEGAL_TYPE
     * @var \StructType\Literal[]
     */
    public $RESOURCE_LEGAL_TYPE;
    /**
     * The RESOURCE_LEGAL_YEAR
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: RESOURCE_LEGAL_YEAR
     * @var \StructType\Literal[]
     */
    public $RESOURCE_LEGAL_YEAR;
    /**
     * The SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL
     */
    public $SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL;
    /**
     * The SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     */
    public $SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE;
    /**
     * The SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL
     */
    public $SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL;
    /**
     * The SPECIAL_OFFICIAL_JOURNAL_VOLUME
     */
    public $SPECIAL_OFFICIAL_JOURNAL_VOLUME;
    /**
     * The WORK_DATE_DOCUMENT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: WORK_DATE_DOCUMENT
     * @var \StructType\Date[]
     */
    public $WORK_DATE_DOCUMENT;
    /**
     * The WORK_IS_ABOUT_CONCEPT_EUROVOC
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: WORK_IS_ABOUT_CONCEPT_EUROVOC
     * @var \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC[]
     */
    public $WORK_IS_ABOUT_CONCEPT_EUROVOC;
    /**
     * The SAMEAS
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: SAMEAS
     * @var \StructType\SAMEAS[]
     */
    public $SAMEAS;
    /**
     * The TYPE
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: TYPE
     * @var \StructType\Relation[]
     */
    public $TYPE;
    /**
     * The URI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\URI
     */
    public $URI;
    /**
     * Constructor method for embeddedWorkType
     * @uses EmbeddedWorkType::setCONTAINER_CASE_LAW_COURT()
     * @uses EmbeddedWorkType::setCONTAINER_CASE_LAW_FASCICULE()
     * @uses EmbeddedWorkType::setCONTAINER_CASE_LAW_ID_NUMPUB()
     * @uses EmbeddedWorkType::setCONTAINER_CASE_LAW_NUMBER()
     * @uses EmbeddedWorkType::setCONTAINER_CASE_LAW_YEAR_DECISION()
     * @uses EmbeddedWorkType::setCOURT_REPORT_NUMBER()
     * @uses EmbeddedWorkType::setDATE_PUBLICATION()
     * @uses EmbeddedWorkType::setID_SECTOR()
     * @uses EmbeddedWorkType::setLEGAL_EFFECT_PAPER()
     * @uses EmbeddedWorkType::setOFFICIAL_JOURNAL_CLASS()
     * @uses EmbeddedWorkType::setOFFICIAL_JOURNAL_NUMBER()
     * @uses EmbeddedWorkType::setOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT()
     * @uses EmbeddedWorkType::setOFFICIAL_JOURNAL_YEAR()
     * @uses EmbeddedWorkType::setRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE()
     * @uses EmbeddedWorkType::setRESOURCE_LEGAL_NUMBER_NATURAL_CELEX()
     * @uses EmbeddedWorkType::setRESOURCE_LEGAL_TYPE()
     * @uses EmbeddedWorkType::setRESOURCE_LEGAL_YEAR()
     * @uses EmbeddedWorkType::setSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL()
     * @uses EmbeddedWorkType::setSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE()
     * @uses EmbeddedWorkType::setSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL()
     * @uses EmbeddedWorkType::setSPECIAL_OFFICIAL_JOURNAL_VOLUME()
     * @uses EmbeddedWorkType::setWORK_DATE_DOCUMENT()
     * @uses EmbeddedWorkType::setWORK_IS_ABOUT_CONCEPT_EUROVOC()
     * @uses EmbeddedWorkType::setSAMEAS()
     * @uses EmbeddedWorkType::setTYPE()
     * @uses EmbeddedWorkType::setURI()
     * @param \StructType\Literal[] $cONTAINER_CASE_LAW_COURT
     * @param \StructType\Literal[] $cONTAINER_CASE_LAW_FASCICULE
     * @param \StructType\Literal[] $cONTAINER_CASE_LAW_ID_NUMPUB
     * @param \StructType\Literal[] $cONTAINER_CASE_LAW_NUMBER
     * @param \StructType\Literal[] $cONTAINER_CASE_LAW_YEAR_DECISION
     * @param \StructType\Literal[] $cOURT_REPORT_NUMBER
     * @param \StructType\Date[] $dATE_PUBLICATION
     * @param \StructType\Literal[] $iD_SECTOR
     * @param \StructType\Literal[] $lEGAL_EFFECT_PAPER
     * @param \StructType\Literal[] $oFFICIAL_JOURNAL_CLASS
     * @param \StructType\Literal[] $oFFICIAL_JOURNAL_NUMBER
     * @param \StructType\Concept[] $oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT
     * @param \StructType\Literal[] $oFFICIAL_JOURNAL_YEAR
     * @param \StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE[] $rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     * @param \StructType\Literal[] $rESOURCE_LEGAL_NUMBER_NATURAL_CELEX
     * @param \StructType\Literal[] $rESOURCE_LEGAL_TYPE
     * @param \StructType\Literal[] $rESOURCE_LEGAL_YEAR
     * @param \StructType\Literal[] $sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL
     * @param \StructType\Concept[] $sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     * @param \StructType\Literal[] $sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL
     * @param \StructType\Literal[] $sPECIAL_OFFICIAL_JOURNAL_VOLUME
     * @param \StructType\Date[] $wORK_DATE_DOCUMENT
     * @param \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC[] $wORK_IS_ABOUT_CONCEPT_EUROVOC
     * @param \StructType\SAMEAS[] $sAMEAS
     * @param \StructType\Relation[] $tYPE
     * @param \StructType\URI $uRI
     */
    public function __construct(array $cONTAINER_CASE_LAW_COURT = array(), array $cONTAINER_CASE_LAW_FASCICULE = array(), array $cONTAINER_CASE_LAW_ID_NUMPUB = array(), array $cONTAINER_CASE_LAW_NUMBER = array(), array $cONTAINER_CASE_LAW_YEAR_DECISION = array(), array $cOURT_REPORT_NUMBER = array(), array $dATE_PUBLICATION = array(), array $iD_SECTOR = array(), array $lEGAL_EFFECT_PAPER = array(), array $oFFICIAL_JOURNAL_CLASS = array(), array $oFFICIAL_JOURNAL_NUMBER = array(), array $oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT = array(), array $oFFICIAL_JOURNAL_YEAR = array(), array $rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = array(), array $rESOURCE_LEGAL_NUMBER_NATURAL_CELEX = array(), array $rESOURCE_LEGAL_TYPE = array(), array $rESOURCE_LEGAL_YEAR = array(), array $sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL = array(), array $sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = array(), array $sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL = array(), array $sPECIAL_OFFICIAL_JOURNAL_VOLUME = array(), array $wORK_DATE_DOCUMENT = array(), array $wORK_IS_ABOUT_CONCEPT_EUROVOC = array(), array $sAMEAS = array(), array $tYPE = array(), \StructType\URI $uRI = null)
    {
        $this
            ->setCONTAINER_CASE_LAW_COURT($cONTAINER_CASE_LAW_COURT)
            ->setCONTAINER_CASE_LAW_FASCICULE($cONTAINER_CASE_LAW_FASCICULE)
            ->setCONTAINER_CASE_LAW_ID_NUMPUB($cONTAINER_CASE_LAW_ID_NUMPUB)
            ->setCONTAINER_CASE_LAW_NUMBER($cONTAINER_CASE_LAW_NUMBER)
            ->setCONTAINER_CASE_LAW_YEAR_DECISION($cONTAINER_CASE_LAW_YEAR_DECISION)
            ->setCOURT_REPORT_NUMBER($cOURT_REPORT_NUMBER)
            ->setDATE_PUBLICATION($dATE_PUBLICATION)
            ->setID_SECTOR($iD_SECTOR)
            ->setLEGAL_EFFECT_PAPER($lEGAL_EFFECT_PAPER)
            ->setOFFICIAL_JOURNAL_CLASS($oFFICIAL_JOURNAL_CLASS)
            ->setOFFICIAL_JOURNAL_NUMBER($oFFICIAL_JOURNAL_NUMBER)
            ->setOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT($oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT)
            ->setOFFICIAL_JOURNAL_YEAR($oFFICIAL_JOURNAL_YEAR)
            ->setRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE($rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE)
            ->setRESOURCE_LEGAL_NUMBER_NATURAL_CELEX($rESOURCE_LEGAL_NUMBER_NATURAL_CELEX)
            ->setRESOURCE_LEGAL_TYPE($rESOURCE_LEGAL_TYPE)
            ->setRESOURCE_LEGAL_YEAR($rESOURCE_LEGAL_YEAR)
            ->setSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL($sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL)
            ->setSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE($sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE)
            ->setSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL($sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL)
            ->setSPECIAL_OFFICIAL_JOURNAL_VOLUME($sPECIAL_OFFICIAL_JOURNAL_VOLUME)
            ->setWORK_DATE_DOCUMENT($wORK_DATE_DOCUMENT)
            ->setWORK_IS_ABOUT_CONCEPT_EUROVOC($wORK_IS_ABOUT_CONCEPT_EUROVOC)
            ->setSAMEAS($sAMEAS)
            ->setTYPE($tYPE)
            ->setURI($uRI);
    }
    /**
     * Get cONTAINER_CASE_LAW_COURT value
     * @return cONTAINER_CASE_LAW_COURT
     */
    public function getCONTAINER_CASE_LAW_COURT()
    {
        return $this->{'CONTAINER_CASE-LAW_COURT'};
    }
    /**
     * Set cONTAINER_CASE_LAW_COURT value
     * @param cONTAINER_CASE_LAW_COURT $cONTAINER_CASE_LAW_COURT
     * @return \StructType\EmbeddedWorkType
     */
    public function setCONTAINER_CASE_LAW_COURT(array $cONTAINER_CASE_LAW_COURT = array())
    {
        foreach ($cONTAINER_CASE_LAW_COURT as $embeddedWorkTypeCONTAINER_CASE_LAW_COURTItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCONTAINER_CASE_LAW_COURTItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_COURT property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCONTAINER_CASE_LAW_COURTItem) ? get_class($embeddedWorkTypeCONTAINER_CASE_LAW_COURTItem) : gettype($embeddedWorkTypeCONTAINER_CASE_LAW_COURTItem)), __LINE__);
            }
        }
        $this->CONTAINER_CASE_LAW_COURT = $this->{'CONTAINER_CASE-LAW_COURT'} = $cONTAINER_CASE_LAW_COURT;
        return $this;
    }
    /**
     */
    public function addToCONTAINER_CASE_LAW_COURT(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_COURT property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CONTAINER_CASE_LAW_COURT[] = $item;
        return $this;
    }
    /**
     * Get cONTAINER_CASE_LAW_FASCICULE value
     * @return cONTAINER_CASE_LAW_FASCICULE
     */
    public function getCONTAINER_CASE_LAW_FASCICULE()
    {
        return $this->{'CONTAINER_CASE-LAW_FASCICULE'};
    }
    /**
     * Set cONTAINER_CASE_LAW_FASCICULE value
     * @param cONTAINER_CASE_LAW_FASCICULE $cONTAINER_CASE_LAW_FASCICULE
     * @return \StructType\EmbeddedWorkType
     */
    public function setCONTAINER_CASE_LAW_FASCICULE(array $cONTAINER_CASE_LAW_FASCICULE = array())
    {
        foreach ($cONTAINER_CASE_LAW_FASCICULE as $embeddedWorkTypeCONTAINER_CASE_LAW_FASCICULEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCONTAINER_CASE_LAW_FASCICULEItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_FASCICULE property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCONTAINER_CASE_LAW_FASCICULEItem) ? get_class($embeddedWorkTypeCONTAINER_CASE_LAW_FASCICULEItem) : gettype($embeddedWorkTypeCONTAINER_CASE_LAW_FASCICULEItem)), __LINE__);
            }
        }
        $this->CONTAINER_CASE_LAW_FASCICULE = $this->{'CONTAINER_CASE-LAW_FASCICULE'} = $cONTAINER_CASE_LAW_FASCICULE;
        return $this;
    }
    /**
     */
    public function addToCONTAINER_CASE_LAW_FASCICULE(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_FASCICULE property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CONTAINER_CASE_LAW_FASCICULE[] = $item;
        return $this;
    }
    /**
     * Get cONTAINER_CASE_LAW_ID_NUMPUB value
     * @return cONTAINER_CASE_LAW_ID_NUMPUB
     */
    public function getCONTAINER_CASE_LAW_ID_NUMPUB()
    {
        return $this->{'CONTAINER_CASE-LAW_ID_NUMPUB'};
    }
    /**
     * Set cONTAINER_CASE_LAW_ID_NUMPUB value
     * @param cONTAINER_CASE_LAW_ID_NUMPUB $cONTAINER_CASE_LAW_ID_NUMPUB
     * @return \StructType\EmbeddedWorkType
     */
    public function setCONTAINER_CASE_LAW_ID_NUMPUB(array $cONTAINER_CASE_LAW_ID_NUMPUB = array())
    {
        foreach ($cONTAINER_CASE_LAW_ID_NUMPUB as $embeddedWorkTypeCONTAINER_CASE_LAW_ID_NUMPUBItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCONTAINER_CASE_LAW_ID_NUMPUBItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_ID_NUMPUB property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCONTAINER_CASE_LAW_ID_NUMPUBItem) ? get_class($embeddedWorkTypeCONTAINER_CASE_LAW_ID_NUMPUBItem) : gettype($embeddedWorkTypeCONTAINER_CASE_LAW_ID_NUMPUBItem)), __LINE__);
            }
        }
        $this->CONTAINER_CASE_LAW_ID_NUMPUB = $this->{'CONTAINER_CASE-LAW_ID_NUMPUB'} = $cONTAINER_CASE_LAW_ID_NUMPUB;
        return $this;
    }
    /**
     */
    public function addToCONTAINER_CASE_LAW_ID_NUMPUB(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_ID_NUMPUB property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CONTAINER_CASE_LAW_ID_NUMPUB[] = $item;
        return $this;
    }
    /**
     * Get cONTAINER_CASE_LAW_NUMBER value
     * @return cONTAINER_CASE_LAW_NUMBER
     */
    public function getCONTAINER_CASE_LAW_NUMBER()
    {
        return $this->{'CONTAINER_CASE-LAW_NUMBER'};
    }
    /**
     * Set cONTAINER_CASE_LAW_NUMBER value
     * @param cONTAINER_CASE_LAW_NUMBER $cONTAINER_CASE_LAW_NUMBER
     * @return \StructType\EmbeddedWorkType
     */
    public function setCONTAINER_CASE_LAW_NUMBER(array $cONTAINER_CASE_LAW_NUMBER = array())
    {
        foreach ($cONTAINER_CASE_LAW_NUMBER as $embeddedWorkTypeCONTAINER_CASE_LAW_NUMBERItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCONTAINER_CASE_LAW_NUMBERItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCONTAINER_CASE_LAW_NUMBERItem) ? get_class($embeddedWorkTypeCONTAINER_CASE_LAW_NUMBERItem) : gettype($embeddedWorkTypeCONTAINER_CASE_LAW_NUMBERItem)), __LINE__);
            }
        }
        $this->CONTAINER_CASE_LAW_NUMBER = $this->{'CONTAINER_CASE-LAW_NUMBER'} = $cONTAINER_CASE_LAW_NUMBER;
        return $this;
    }
    /**
     */
    public function addToCONTAINER_CASE_LAW_NUMBER(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CONTAINER_CASE_LAW_NUMBER[] = $item;
        return $this;
    }
    /**
     * Get cONTAINER_CASE_LAW_YEAR_DECISION value
     * @return cONTAINER_CASE_LAW_YEAR_DECISION
     */
    public function getCONTAINER_CASE_LAW_YEAR_DECISION()
    {
        return $this->{'CONTAINER_CASE-LAW_YEAR_DECISION'};
    }
    /**
     * Set cONTAINER_CASE_LAW_YEAR_DECISION value
     * @param cONTAINER_CASE_LAW_YEAR_DECISION $cONTAINER_CASE_LAW_YEAR_DECISION
     * @return \StructType\EmbeddedWorkType
     */
    public function setCONTAINER_CASE_LAW_YEAR_DECISION(array $cONTAINER_CASE_LAW_YEAR_DECISION = array())
    {
        foreach ($cONTAINER_CASE_LAW_YEAR_DECISION as $embeddedWorkTypeCONTAINER_CASE_LAW_YEAR_DECISIONItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCONTAINER_CASE_LAW_YEAR_DECISIONItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_YEAR_DECISION property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCONTAINER_CASE_LAW_YEAR_DECISIONItem) ? get_class($embeddedWorkTypeCONTAINER_CASE_LAW_YEAR_DECISIONItem) : gettype($embeddedWorkTypeCONTAINER_CASE_LAW_YEAR_DECISIONItem)), __LINE__);
            }
        }
        $this->CONTAINER_CASE_LAW_YEAR_DECISION = $this->{'CONTAINER_CASE-LAW_YEAR_DECISION'} = $cONTAINER_CASE_LAW_YEAR_DECISION;
        return $this;
    }
    /**
     */
    public function addToCONTAINER_CASE_LAW_YEAR_DECISION(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The CONTAINER_CASE_LAW_YEAR_DECISION property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CONTAINER_CASE_LAW_YEAR_DECISION[] = $item;
        return $this;
    }
    /**
     * Get cOURT_REPORT_NUMBER value
     * @return cOURT_REPORT_NUMBER
     */
    public function getCOURT_REPORT_NUMBER()
    {
        return $this->{'COURT-REPORT_NUMBER'};
    }
    /**
     * Set cOURT_REPORT_NUMBER value
     * @param cOURT_REPORT_NUMBER $cOURT_REPORT_NUMBER
     * @return \StructType\EmbeddedWorkType
     */
    public function setCOURT_REPORT_NUMBER(array $cOURT_REPORT_NUMBER = array())
    {
        foreach ($cOURT_REPORT_NUMBER as $embeddedWorkTypeCOURT_REPORT_NUMBERItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeCOURT_REPORT_NUMBERItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The COURT_REPORT_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeCOURT_REPORT_NUMBERItem) ? get_class($embeddedWorkTypeCOURT_REPORT_NUMBERItem) : gettype($embeddedWorkTypeCOURT_REPORT_NUMBERItem)), __LINE__);
            }
        }
        $this->COURT_REPORT_NUMBER = $this->{'COURT-REPORT_NUMBER'} = $cOURT_REPORT_NUMBER;
        return $this;
    }
    /**
     */
    public function addToCOURT_REPORT_NUMBER(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The COURT_REPORT_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->COURT_REPORT_NUMBER[] = $item;
        return $this;
    }
    /**
     * Get DATE_PUBLICATION value
     * @return \StructType\Date[]|null
     */
    public function getDATE_PUBLICATION()
    {
        return $this->DATE_PUBLICATION;
    }
    /**
     * Set DATE_PUBLICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $dATE_PUBLICATION
     * @return \StructType\EmbeddedWorkType
     */
    public function setDATE_PUBLICATION(array $dATE_PUBLICATION = array())
    {
        foreach ($dATE_PUBLICATION as $embeddedWorkTypeDATE_PUBLICATIONItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeDATE_PUBLICATIONItem instanceof \StructType\Date) {
                throw new \InvalidArgumentException(sprintf('The DATE_PUBLICATION property can only contain items of \StructType\Date, "%s" given', is_object($embeddedWorkTypeDATE_PUBLICATIONItem) ? get_class($embeddedWorkTypeDATE_PUBLICATIONItem) : gettype($embeddedWorkTypeDATE_PUBLICATIONItem)), __LINE__);
            }
        }
        $this->DATE_PUBLICATION = $dATE_PUBLICATION;
        return $this;
    }
    /**
     * Add item to DATE_PUBLICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToDATE_PUBLICATION(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The DATE_PUBLICATION property can only contain items of \StructType\Date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DATE_PUBLICATION[] = $item;
        return $this;
    }
    /**
     * Get ID_SECTOR value
     * @return \StructType\Literal[]|null
     */
    public function getID_SECTOR()
    {
        return $this->ID_SECTOR;
    }
    /**
     * Set ID_SECTOR value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal[] $iD_SECTOR
     * @return \StructType\EmbeddedWorkType
     */
    public function setID_SECTOR(array $iD_SECTOR = array())
    {
        foreach ($iD_SECTOR as $embeddedWorkTypeID_SECTORItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeID_SECTORItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The ID_SECTOR property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeID_SECTORItem) ? get_class($embeddedWorkTypeID_SECTORItem) : gettype($embeddedWorkTypeID_SECTORItem)), __LINE__);
            }
        }
        $this->ID_SECTOR = $iD_SECTOR;
        return $this;
    }
    /**
     * Add item to ID_SECTOR value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToID_SECTOR(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The ID_SECTOR property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ID_SECTOR[] = $item;
        return $this;
    }
    /**
     * Get LEGAL_EFFECT_PAPER value
     * @return \StructType\Literal[]|null
     */
    public function getLEGAL_EFFECT_PAPER()
    {
        return $this->LEGAL_EFFECT_PAPER;
    }
    /**
     * Set LEGAL_EFFECT_PAPER value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal[] $lEGAL_EFFECT_PAPER
     * @return \StructType\EmbeddedWorkType
     */
    public function setLEGAL_EFFECT_PAPER(array $lEGAL_EFFECT_PAPER = array())
    {
        foreach ($lEGAL_EFFECT_PAPER as $embeddedWorkTypeLEGAL_EFFECT_PAPERItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeLEGAL_EFFECT_PAPERItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The LEGAL_EFFECT_PAPER property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeLEGAL_EFFECT_PAPERItem) ? get_class($embeddedWorkTypeLEGAL_EFFECT_PAPERItem) : gettype($embeddedWorkTypeLEGAL_EFFECT_PAPERItem)), __LINE__);
            }
        }
        $this->LEGAL_EFFECT_PAPER = $lEGAL_EFFECT_PAPER;
        return $this;
    }
    /**
     * Add item to LEGAL_EFFECT_PAPER value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToLEGAL_EFFECT_PAPER(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The LEGAL_EFFECT_PAPER property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LEGAL_EFFECT_PAPER[] = $item;
        return $this;
    }
    /**
     * Get oFFICIAL_JOURNAL_CLASS value
     * @return oFFICIAL_JOURNAL_CLASS
     */
    public function getOFFICIAL_JOURNAL_CLASS()
    {
        return $this->{'OFFICIAL-JOURNAL_CLASS'};
    }
    /**
     * Set oFFICIAL_JOURNAL_CLASS value
     * @param oFFICIAL_JOURNAL_CLASS $oFFICIAL_JOURNAL_CLASS
     * @return \StructType\EmbeddedWorkType
     */
    public function setOFFICIAL_JOURNAL_CLASS(array $oFFICIAL_JOURNAL_CLASS = array())
    {
        foreach ($oFFICIAL_JOURNAL_CLASS as $embeddedWorkTypeOFFICIAL_JOURNAL_CLASSItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeOFFICIAL_JOURNAL_CLASSItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_CLASS property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeOFFICIAL_JOURNAL_CLASSItem) ? get_class($embeddedWorkTypeOFFICIAL_JOURNAL_CLASSItem) : gettype($embeddedWorkTypeOFFICIAL_JOURNAL_CLASSItem)), __LINE__);
            }
        }
        $this->OFFICIAL_JOURNAL_CLASS = $this->{'OFFICIAL-JOURNAL_CLASS'} = $oFFICIAL_JOURNAL_CLASS;
        return $this;
    }
    /**
     */
    public function addToOFFICIAL_JOURNAL_CLASS(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_CLASS property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OFFICIAL_JOURNAL_CLASS[] = $item;
        return $this;
    }
    /**
     * Get oFFICIAL_JOURNAL_NUMBER value
     * @return oFFICIAL_JOURNAL_NUMBER
     */
    public function getOFFICIAL_JOURNAL_NUMBER()
    {
        return $this->{'OFFICIAL-JOURNAL_NUMBER'};
    }
    /**
     * Set oFFICIAL_JOURNAL_NUMBER value
     * @param oFFICIAL_JOURNAL_NUMBER $oFFICIAL_JOURNAL_NUMBER
     * @return \StructType\EmbeddedWorkType
     */
    public function setOFFICIAL_JOURNAL_NUMBER(array $oFFICIAL_JOURNAL_NUMBER = array())
    {
        foreach ($oFFICIAL_JOURNAL_NUMBER as $embeddedWorkTypeOFFICIAL_JOURNAL_NUMBERItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeOFFICIAL_JOURNAL_NUMBERItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeOFFICIAL_JOURNAL_NUMBERItem) ? get_class($embeddedWorkTypeOFFICIAL_JOURNAL_NUMBERItem) : gettype($embeddedWorkTypeOFFICIAL_JOURNAL_NUMBERItem)), __LINE__);
            }
        }
        $this->OFFICIAL_JOURNAL_NUMBER = $this->{'OFFICIAL-JOURNAL_NUMBER'} = $oFFICIAL_JOURNAL_NUMBER;
        return $this;
    }
    /**
     */
    public function addToOFFICIAL_JOURNAL_NUMBER(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_NUMBER property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OFFICIAL_JOURNAL_NUMBER[] = $item;
        return $this;
    }
    /**
     * Get oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT value
     * @return oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT
     */
    public function getOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT()
    {
        return $this->{'OFFICIAL-JOURNAL_PART_OF_COLLECTION_DOCUMENT'};
    }
    /**
     * Set oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT value
     * @param oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT $oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT
     * @return \StructType\EmbeddedWorkType
     */
    public function setOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT(array $oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT = array())
    {
        foreach ($oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT as $embeddedWorkTypeOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENTItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENTItem instanceof \StructType\Concept) {
                throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT property can only contain items of \StructType\Concept, "%s" given', is_object($embeddedWorkTypeOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENTItem) ? get_class($embeddedWorkTypeOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENTItem) : gettype($embeddedWorkTypeOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENTItem)), __LINE__);
            }
        }
        $this->OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT = $this->{'OFFICIAL-JOURNAL_PART_OF_COLLECTION_DOCUMENT'} = $oFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT;
        return $this;
    }
    /**
     */
    public function addToOFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT(\StructType\Concept $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Concept) {
            throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT property can only contain items of \StructType\Concept, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OFFICIAL_JOURNAL_PART_OF_COLLECTION_DOCUMENT[] = $item;
        return $this;
    }
    /**
     * Get oFFICIAL_JOURNAL_YEAR value
     * @return oFFICIAL_JOURNAL_YEAR
     */
    public function getOFFICIAL_JOURNAL_YEAR()
    {
        return $this->{'OFFICIAL-JOURNAL_YEAR'};
    }
    /**
     * Set oFFICIAL_JOURNAL_YEAR value
     * @param oFFICIAL_JOURNAL_YEAR $oFFICIAL_JOURNAL_YEAR
     * @return \StructType\EmbeddedWorkType
     */
    public function setOFFICIAL_JOURNAL_YEAR(array $oFFICIAL_JOURNAL_YEAR = array())
    {
        foreach ($oFFICIAL_JOURNAL_YEAR as $embeddedWorkTypeOFFICIAL_JOURNAL_YEARItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeOFFICIAL_JOURNAL_YEARItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_YEAR property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeOFFICIAL_JOURNAL_YEARItem) ? get_class($embeddedWorkTypeOFFICIAL_JOURNAL_YEARItem) : gettype($embeddedWorkTypeOFFICIAL_JOURNAL_YEARItem)), __LINE__);
            }
        }
        $this->OFFICIAL_JOURNAL_YEAR = $this->{'OFFICIAL-JOURNAL_YEAR'} = $oFFICIAL_JOURNAL_YEAR;
        return $this;
    }
    /**
     */
    public function addToOFFICIAL_JOURNAL_YEAR(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The OFFICIAL_JOURNAL_YEAR property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OFFICIAL_JOURNAL_YEAR[] = $item;
        return $this;
    }
    /**
     * Get rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE value
     * @return rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     */
    public function getRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE()
    {
        return $this->{'RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY-CODE'};
    }
    /**
     * Set rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE value
     * @param rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE $rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     * @return \StructType\EmbeddedWorkType
     */
    public function setRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE(array $rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = array())
    {
        foreach ($rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE as $embeddedWorkTypeRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem instanceof \StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE) {
                throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE property can only contain items of \StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE, "%s" given', is_object($embeddedWorkTypeRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) ? get_class($embeddedWorkTypeRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) : gettype($embeddedWorkTypeRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem)), __LINE__);
            }
        }
        $this->RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = $this->{'RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY-CODE'} = $rESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE;
        return $this;
    }
    /**
     */
    public function addToRESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE(\StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE) {
            throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE property can only contain items of \StructType\RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RESOURCE_LEGAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE[] = $item;
        return $this;
    }
    /**
     * Get RESOURCE_LEGAL_NUMBER_NATURAL_CELEX value
     * @return \StructType\Literal[]|null
     */
    public function getRESOURCE_LEGAL_NUMBER_NATURAL_CELEX()
    {
        return $this->RESOURCE_LEGAL_NUMBER_NATURAL_CELEX;
    }
    /**
     * Set RESOURCE_LEGAL_NUMBER_NATURAL_CELEX value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal[] $rESOURCE_LEGAL_NUMBER_NATURAL_CELEX
     * @return \StructType\EmbeddedWorkType
     */
    public function setRESOURCE_LEGAL_NUMBER_NATURAL_CELEX(array $rESOURCE_LEGAL_NUMBER_NATURAL_CELEX = array())
    {
        foreach ($rESOURCE_LEGAL_NUMBER_NATURAL_CELEX as $embeddedWorkTypeRESOURCE_LEGAL_NUMBER_NATURAL_CELEXItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeRESOURCE_LEGAL_NUMBER_NATURAL_CELEXItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_NUMBER_NATURAL_CELEX property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeRESOURCE_LEGAL_NUMBER_NATURAL_CELEXItem) ? get_class($embeddedWorkTypeRESOURCE_LEGAL_NUMBER_NATURAL_CELEXItem) : gettype($embeddedWorkTypeRESOURCE_LEGAL_NUMBER_NATURAL_CELEXItem)), __LINE__);
            }
        }
        $this->RESOURCE_LEGAL_NUMBER_NATURAL_CELEX = $rESOURCE_LEGAL_NUMBER_NATURAL_CELEX;
        return $this;
    }
    /**
     * Add item to RESOURCE_LEGAL_NUMBER_NATURAL_CELEX value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToRESOURCE_LEGAL_NUMBER_NATURAL_CELEX(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_NUMBER_NATURAL_CELEX property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RESOURCE_LEGAL_NUMBER_NATURAL_CELEX[] = $item;
        return $this;
    }
    /**
     * Get RESOURCE_LEGAL_TYPE value
     * @return \StructType\Literal[]|null
     */
    public function getRESOURCE_LEGAL_TYPE()
    {
        return $this->RESOURCE_LEGAL_TYPE;
    }
    /**
     * Set RESOURCE_LEGAL_TYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal[] $rESOURCE_LEGAL_TYPE
     * @return \StructType\EmbeddedWorkType
     */
    public function setRESOURCE_LEGAL_TYPE(array $rESOURCE_LEGAL_TYPE = array())
    {
        foreach ($rESOURCE_LEGAL_TYPE as $embeddedWorkTypeRESOURCE_LEGAL_TYPEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeRESOURCE_LEGAL_TYPEItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_TYPE property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeRESOURCE_LEGAL_TYPEItem) ? get_class($embeddedWorkTypeRESOURCE_LEGAL_TYPEItem) : gettype($embeddedWorkTypeRESOURCE_LEGAL_TYPEItem)), __LINE__);
            }
        }
        $this->RESOURCE_LEGAL_TYPE = $rESOURCE_LEGAL_TYPE;
        return $this;
    }
    /**
     * Add item to RESOURCE_LEGAL_TYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToRESOURCE_LEGAL_TYPE(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_TYPE property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RESOURCE_LEGAL_TYPE[] = $item;
        return $this;
    }
    /**
     * Get RESOURCE_LEGAL_YEAR value
     * @return \StructType\Literal[]|null
     */
    public function getRESOURCE_LEGAL_YEAR()
    {
        return $this->RESOURCE_LEGAL_YEAR;
    }
    /**
     * Set RESOURCE_LEGAL_YEAR value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal[] $rESOURCE_LEGAL_YEAR
     * @return \StructType\EmbeddedWorkType
     */
    public function setRESOURCE_LEGAL_YEAR(array $rESOURCE_LEGAL_YEAR = array())
    {
        foreach ($rESOURCE_LEGAL_YEAR as $embeddedWorkTypeRESOURCE_LEGAL_YEARItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeRESOURCE_LEGAL_YEARItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_YEAR property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeRESOURCE_LEGAL_YEARItem) ? get_class($embeddedWorkTypeRESOURCE_LEGAL_YEARItem) : gettype($embeddedWorkTypeRESOURCE_LEGAL_YEARItem)), __LINE__);
            }
        }
        $this->RESOURCE_LEGAL_YEAR = $rESOURCE_LEGAL_YEAR;
        return $this;
    }
    /**
     * Add item to RESOURCE_LEGAL_YEAR value
     * @throws \InvalidArgumentException
     * @param \StructType\Literal $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToRESOURCE_LEGAL_YEAR(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The RESOURCE_LEGAL_YEAR property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RESOURCE_LEGAL_YEAR[] = $item;
        return $this;
    }
    /**
     * Get sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL value
     * @return sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL
     */
    public function getSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL()
    {
        return $this->{'SPECIAL-OFFICIAL-JOURNAL_FIRST_SERIES_HISTORICAL'};
    }
    /**
     * Set sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL value
     * @param sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL $sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL
     * @return \StructType\EmbeddedWorkType
     */
    public function setSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL(array $sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL = array())
    {
        foreach ($sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL as $embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICALItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICALItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICALItem) ? get_class($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICALItem) : gettype($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICALItem)), __LINE__);
            }
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL = $this->{'SPECIAL-OFFICIAL-JOURNAL_FIRST_SERIES_HISTORICAL'} = $sPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL;
        return $this;
    }
    /**
     */
    public function addToSPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_FIRST_SERIES_HISTORICAL[] = $item;
        return $this;
    }
    /**
     * Get sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE value
     * @return sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     */
    public function getSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE()
    {
        return $this->{'SPECIAL-OFFICIAL-JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY-CODE'};
    }
    /**
     * Set sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE value
     * @param sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE $sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE
     * @return \StructType\EmbeddedWorkType
     */
    public function setSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE(array $sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = array())
    {
        foreach ($sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE as $embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem instanceof \StructType\Concept) {
                throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE property can only contain items of \StructType\Concept, "%s" given', is_object($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) ? get_class($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem) : gettype($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODEItem)), __LINE__);
            }
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE = $this->{'SPECIAL-OFFICIAL-JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY-CODE'} = $sPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE;
        return $this;
    }
    /**
     */
    public function addToSPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE(\StructType\Concept $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Concept) {
            throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE property can only contain items of \StructType\Concept, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_IS_ABOUT_CONCEPT_DIRECTORY_CODE[] = $item;
        return $this;
    }
    /**
     * Get sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL value
     * @return sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL
     */
    public function getSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL()
    {
        return $this->{'SPECIAL-OFFICIAL-JOURNAL_SECOND_SERIES_HISTORICAL'};
    }
    /**
     * Set sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL value
     * @param sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL $sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL
     * @return \StructType\EmbeddedWorkType
     */
    public function setSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL(array $sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL = array())
    {
        foreach ($sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL as $embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICALItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICALItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICALItem) ? get_class($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICALItem) : gettype($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICALItem)), __LINE__);
            }
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL = $this->{'SPECIAL-OFFICIAL-JOURNAL_SECOND_SERIES_HISTORICAL'} = $sPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL;
        return $this;
    }
    /**
     */
    public function addToSPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_SECOND_SERIES_HISTORICAL[] = $item;
        return $this;
    }
    /**
     * Get sPECIAL_OFFICIAL_JOURNAL_VOLUME value
     * @return sPECIAL_OFFICIAL_JOURNAL_VOLUME
     */
    public function getSPECIAL_OFFICIAL_JOURNAL_VOLUME()
    {
        return $this->{'SPECIAL-OFFICIAL-JOURNAL_VOLUME'};
    }
    /**
     * Set sPECIAL_OFFICIAL_JOURNAL_VOLUME value
     * @param sPECIAL_OFFICIAL_JOURNAL_VOLUME $sPECIAL_OFFICIAL_JOURNAL_VOLUME
     * @return \StructType\EmbeddedWorkType
     */
    public function setSPECIAL_OFFICIAL_JOURNAL_VOLUME(array $sPECIAL_OFFICIAL_JOURNAL_VOLUME = array())
    {
        foreach ($sPECIAL_OFFICIAL_JOURNAL_VOLUME as $embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_VOLUMEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_VOLUMEItem instanceof \StructType\Literal) {
                throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_VOLUME property can only contain items of \StructType\Literal, "%s" given', is_object($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_VOLUMEItem) ? get_class($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_VOLUMEItem) : gettype($embeddedWorkTypeSPECIAL_OFFICIAL_JOURNAL_VOLUMEItem)), __LINE__);
            }
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_VOLUME = $this->{'SPECIAL-OFFICIAL-JOURNAL_VOLUME'} = $sPECIAL_OFFICIAL_JOURNAL_VOLUME;
        return $this;
    }
    /**
     */
    public function addToSPECIAL_OFFICIAL_JOURNAL_VOLUME(\StructType\Literal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Literal) {
            throw new \InvalidArgumentException(sprintf('The SPECIAL_OFFICIAL_JOURNAL_VOLUME property can only contain items of \StructType\Literal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SPECIAL_OFFICIAL_JOURNAL_VOLUME[] = $item;
        return $this;
    }
    /**
     * Get WORK_DATE_DOCUMENT value
     * @return \StructType\Date[]|null
     */
    public function getWORK_DATE_DOCUMENT()
    {
        return $this->WORK_DATE_DOCUMENT;
    }
    /**
     * Set WORK_DATE_DOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $wORK_DATE_DOCUMENT
     * @return \StructType\EmbeddedWorkType
     */
    public function setWORK_DATE_DOCUMENT(array $wORK_DATE_DOCUMENT = array())
    {
        foreach ($wORK_DATE_DOCUMENT as $embeddedWorkTypeWORK_DATE_DOCUMENTItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeWORK_DATE_DOCUMENTItem instanceof \StructType\Date) {
                throw new \InvalidArgumentException(sprintf('The WORK_DATE_DOCUMENT property can only contain items of \StructType\Date, "%s" given', is_object($embeddedWorkTypeWORK_DATE_DOCUMENTItem) ? get_class($embeddedWorkTypeWORK_DATE_DOCUMENTItem) : gettype($embeddedWorkTypeWORK_DATE_DOCUMENTItem)), __LINE__);
            }
        }
        $this->WORK_DATE_DOCUMENT = $wORK_DATE_DOCUMENT;
        return $this;
    }
    /**
     * Add item to WORK_DATE_DOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToWORK_DATE_DOCUMENT(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The WORK_DATE_DOCUMENT property can only contain items of \StructType\Date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WORK_DATE_DOCUMENT[] = $item;
        return $this;
    }
    /**
     * Get WORK_IS_ABOUT_CONCEPT_EUROVOC value
     * @return \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC[]|null
     */
    public function getWORK_IS_ABOUT_CONCEPT_EUROVOC()
    {
        return $this->WORK_IS_ABOUT_CONCEPT_EUROVOC;
    }
    /**
     * Set WORK_IS_ABOUT_CONCEPT_EUROVOC value
     * @throws \InvalidArgumentException
     * @param \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC[] $wORK_IS_ABOUT_CONCEPT_EUROVOC
     * @return \StructType\EmbeddedWorkType
     */
    public function setWORK_IS_ABOUT_CONCEPT_EUROVOC(array $wORK_IS_ABOUT_CONCEPT_EUROVOC = array())
    {
        foreach ($wORK_IS_ABOUT_CONCEPT_EUROVOC as $embeddedWorkTypeWORK_IS_ABOUT_CONCEPT_EUROVOCItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeWORK_IS_ABOUT_CONCEPT_EUROVOCItem instanceof \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC) {
                throw new \InvalidArgumentException(sprintf('The WORK_IS_ABOUT_CONCEPT_EUROVOC property can only contain items of \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC, "%s" given', is_object($embeddedWorkTypeWORK_IS_ABOUT_CONCEPT_EUROVOCItem) ? get_class($embeddedWorkTypeWORK_IS_ABOUT_CONCEPT_EUROVOCItem) : gettype($embeddedWorkTypeWORK_IS_ABOUT_CONCEPT_EUROVOCItem)), __LINE__);
            }
        }
        $this->WORK_IS_ABOUT_CONCEPT_EUROVOC = $wORK_IS_ABOUT_CONCEPT_EUROVOC;
        return $this;
    }
    /**
     * Add item to WORK_IS_ABOUT_CONCEPT_EUROVOC value
     * @throws \InvalidArgumentException
     * @param \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToWORK_IS_ABOUT_CONCEPT_EUROVOC(\StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC) {
            throw new \InvalidArgumentException(sprintf('The WORK_IS_ABOUT_CONCEPT_EUROVOC property can only contain items of \StructType\WORK_IS_ABOUT_CONCEPT_EUROVOC, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WORK_IS_ABOUT_CONCEPT_EUROVOC[] = $item;
        return $this;
    }
    /**
     * Get SAMEAS value
     * @return \StructType\SAMEAS[]|null
     */
    public function getSAMEAS()
    {
        return $this->SAMEAS;
    }
    /**
     * Set SAMEAS value
     * @throws \InvalidArgumentException
     * @param \StructType\SAMEAS[] $sAMEAS
     * @return \StructType\EmbeddedWorkType
     */
    public function setSAMEAS(array $sAMEAS = array())
    {
        foreach ($sAMEAS as $embeddedWorkTypeSAMEASItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeSAMEASItem instanceof \StructType\SAMEAS) {
                throw new \InvalidArgumentException(sprintf('The SAMEAS property can only contain items of \StructType\SAMEAS, "%s" given', is_object($embeddedWorkTypeSAMEASItem) ? get_class($embeddedWorkTypeSAMEASItem) : gettype($embeddedWorkTypeSAMEASItem)), __LINE__);
            }
        }
        $this->SAMEAS = $sAMEAS;
        return $this;
    }
    /**
     * Add item to SAMEAS value
     * @throws \InvalidArgumentException
     * @param \StructType\SAMEAS $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToSAMEAS(\StructType\SAMEAS $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SAMEAS) {
            throw new \InvalidArgumentException(sprintf('The SAMEAS property can only contain items of \StructType\SAMEAS, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SAMEAS[] = $item;
        return $this;
    }
    /**
     * Get TYPE value
     * @return \StructType\Relation[]|null
     */
    public function getTYPE()
    {
        return $this->TYPE;
    }
    /**
     * Set TYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\Relation[] $tYPE
     * @return \StructType\EmbeddedWorkType
     */
    public function setTYPE(array $tYPE = array())
    {
        foreach ($tYPE as $embeddedWorkTypeTYPEItem) {
            // validation for constraint: itemType
            if (!$embeddedWorkTypeTYPEItem instanceof \StructType\Relation) {
                throw new \InvalidArgumentException(sprintf('The TYPE property can only contain items of \StructType\Relation, "%s" given', is_object($embeddedWorkTypeTYPEItem) ? get_class($embeddedWorkTypeTYPEItem) : gettype($embeddedWorkTypeTYPEItem)), __LINE__);
            }
        }
        $this->TYPE = $tYPE;
        return $this;
    }
    /**
     * Add item to TYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\Relation $item
     * @return \StructType\EmbeddedWorkType
     */
    public function addToTYPE(\StructType\Relation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Relation) {
            throw new \InvalidArgumentException(sprintf('The TYPE property can only contain items of \StructType\Relation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TYPE[] = $item;
        return $this;
    }
    /**
     * Get URI value
     * @return \StructType\URI|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param \StructType\URI $uRI
     * @return \StructType\EmbeddedWorkType
     */
    public function setURI(\StructType\URI $uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmbeddedWorkType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
